"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class SearchUsersRequestTypedDict(TypedDict):
    query: NotRequired[str]
    r"""The `query` parameter supports the Zendesk search syntax for more advanced
    user searches. It can specify a partial or full value of any
    user property, including name, email address, notes, or phone. Example:
    `query=\"jdoe\"`.
    See the [Search API](/api-reference/ticketing/ticket-management/search/).

    """
    external_id: NotRequired[str]
    r"""The `external_id` parameter does not support the search syntax. It only accepts ids.

    """


class SearchUsersRequest(BaseModel):
    query: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The `query` parameter supports the Zendesk search syntax for more advanced
    user searches. It can specify a partial or full value of any
    user property, including name, email address, notes, or phone. Example:
    `query=\"jdoe\"`.
    See the [Search API](/api-reference/ticketing/ticket-management/search/).

    """

    external_id: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The `external_id` parameter does not support the search syntax. It only accepts ids.

    """
