"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class SharingAgreementObjectTypedDict(TypedDict):
    created_at: NotRequired[datetime]
    r"""The time the record was created"""
    id: NotRequired[int]
    r"""Automatically assigned upon creation"""
    name: NotRequired[str]
    r"""Name of this sharing agreement"""
    partner_name: NotRequired[Nullable[str]]
    r"""Can be one of the following: \"jira\", null"""
    remote_subdomain: NotRequired[str]
    r"""Subdomain of the remote account or null if not associated with an account"""
    status: NotRequired[str]
    r"""Can be one of the following: \"accepted\", \"declined\", \"pending\", \"inactive\", \"failed\", \"ssl_error\", \"configuration_error\" """
    type: NotRequired[str]
    r"""Can be one of the following: \"inbound\", \"outbound\" """
    updated_at: NotRequired[datetime]
    r"""The time the record was updated"""
    url: NotRequired[str]
    r"""URL of the sharing agreement record"""


class SharingAgreementObject(BaseModel):
    created_at: Optional[datetime] = None
    r"""The time the record was created"""

    id: Optional[int] = None
    r"""Automatically assigned upon creation"""

    name: Optional[str] = None
    r"""Name of this sharing agreement"""

    partner_name: OptionalNullable[str] = UNSET
    r"""Can be one of the following: \"jira\", null"""

    remote_subdomain: Optional[str] = None
    r"""Subdomain of the remote account or null if not associated with an account"""

    status: Optional[str] = None
    r"""Can be one of the following: \"accepted\", \"declined\", \"pending\", \"inactive\", \"failed\", \"ssl_error\", \"configuration_error\" """

    type: Optional[str] = None
    r"""Can be one of the following: \"inbound\", \"outbound\" """

    updated_at: Optional[datetime] = None
    r"""The time the record was updated"""

    url: Optional[str] = None
    r"""URL of the sharing agreement record"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "created_at",
            "id",
            "name",
            "partner_name",
            "remote_subdomain",
            "status",
            "type",
            "updated_at",
            "url",
        ]
        nullable_fields = ["partner_name"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
