"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
import pydantic
from pydantic import ConfigDict
from typing import Any, Dict, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel


class TargetYammerTypedDict(TypedDict):
    title: str
    r"""A name for the target"""
    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""
    group_id: NotRequired[str]
    token: NotRequired[str]
    active: NotRequired[bool]
    r"""Whether or not the target is activated"""
    created_at: NotRequired[datetime]
    r"""The time the target was created"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""


class TargetYammer(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    title: str
    r"""A name for the target"""

    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""

    group_id: Optional[str] = None

    token: Optional[str] = None

    active: Optional[bool] = None
    r"""Whether or not the target is activated"""

    created_at: Optional[datetime] = None
    r"""The time the target was created"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class TargetHTTPTypedDict(TypedDict):
    content_type: str
    r"""\"application/json\", \"application/xml\", or \"application/x-www-form-urlencoded\" """
    method: str
    r"""\"get\", \"patch\", \"put\", \"post\", or \"delete\" """
    target_url: str
    title: str
    r"""A name for the target"""
    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""
    password: NotRequired[str]
    r"""only writable"""
    username: NotRequired[str]
    active: NotRequired[bool]
    r"""Whether or not the target is activated"""
    created_at: NotRequired[datetime]
    r"""The time the target was created"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""


class TargetHTTP(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    content_type: str
    r"""\"application/json\", \"application/xml\", or \"application/x-www-form-urlencoded\" """

    method: str
    r"""\"get\", \"patch\", \"put\", \"post\", or \"delete\" """

    target_url: str

    title: str
    r"""A name for the target"""

    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""

    password: Optional[str] = None
    r"""only writable"""

    username: Optional[str] = None

    active: Optional[bool] = None
    r"""Whether or not the target is activated"""

    created_at: Optional[datetime] = None
    r"""The time the target was created"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class TargetURLTypedDict(TypedDict):
    attribute: str
    target_url: str
    title: str
    r"""A name for the target"""
    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""
    method: NotRequired[str]
    r"""\"get\" """
    password: NotRequired[str]
    r"""only writable"""
    username: NotRequired[str]
    active: NotRequired[bool]
    r"""Whether or not the target is activated"""
    created_at: NotRequired[datetime]
    r"""The time the target was created"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""


class TargetURL(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    attribute: str

    target_url: str

    title: str
    r"""A name for the target"""

    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""

    method: Optional[str] = None
    r"""\"get\" """

    password: Optional[str] = None
    r"""only writable"""

    username: Optional[str] = None

    active: Optional[bool] = None
    r"""Whether or not the target is activated"""

    created_at: Optional[datetime] = None
    r"""The time the target was created"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class TargetTwitterTypedDict(TypedDict):
    title: str
    r"""A name for the target"""
    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""
    secret: NotRequired[str]
    r"""only writable"""
    token: NotRequired[str]
    active: NotRequired[bool]
    r"""Whether or not the target is activated"""
    created_at: NotRequired[datetime]
    r"""The time the target was created"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""


class TargetTwitter(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    title: str
    r"""A name for the target"""

    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""

    secret: Optional[str] = None
    r"""only writable"""

    token: Optional[str] = None

    active: Optional[bool] = None
    r"""Whether or not the target is activated"""

    created_at: Optional[datetime] = None
    r"""The time the target was created"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class TargetPivotalTypedDict(TypedDict):
    project_id: str
    story_title: str
    story_type: str
    token: str
    title: str
    r"""A name for the target"""
    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""
    owner_by: NotRequired[str]
    requested_by: NotRequired[str]
    story_labels: NotRequired[str]
    active: NotRequired[bool]
    r"""Whether or not the target is activated"""
    created_at: NotRequired[datetime]
    r"""The time the target was created"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""


class TargetPivotal(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    project_id: str

    story_title: str

    story_type: str

    token: str

    title: str
    r"""A name for the target"""

    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""

    owner_by: Optional[str] = None

    requested_by: Optional[str] = None

    story_labels: Optional[str] = None

    active: Optional[bool] = None
    r"""Whether or not the target is activated"""

    created_at: Optional[datetime] = None
    r"""The time the target was created"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class TargetJiraTypedDict(TypedDict):
    password: str
    r"""only writable"""
    target_url: str
    username: str
    title: str
    r"""A name for the target"""
    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""
    active: NotRequired[bool]
    r"""Whether or not the target is activated"""
    created_at: NotRequired[datetime]
    r"""The time the target was created"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""


class TargetJira(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    password: str
    r"""only writable"""

    target_url: str

    username: str

    title: str
    r"""A name for the target"""

    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""

    active: Optional[bool] = None
    r"""Whether or not the target is activated"""

    created_at: Optional[datetime] = None
    r"""The time the target was created"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class TargetGetSatisfactionTypedDict(TypedDict):
    account_name: str
    email: str
    password: str
    r"""only writable"""
    title: str
    r"""A name for the target"""
    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""
    target_url: NotRequired[str]
    active: NotRequired[bool]
    r"""Whether or not the target is activated"""
    created_at: NotRequired[datetime]
    r"""The time the target was created"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""


class TargetGetSatisfaction(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    account_name: str

    email: str

    password: str
    r"""only writable"""

    title: str
    r"""A name for the target"""

    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""

    target_url: Optional[str] = None

    active: Optional[bool] = None
    r"""Whether or not the target is activated"""

    created_at: Optional[datetime] = None
    r"""The time the target was created"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class TargetFlowdockTypedDict(TypedDict):
    api_token: str
    title: str
    r"""A name for the target"""
    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""
    active: NotRequired[bool]
    r"""Whether or not the target is activated"""
    created_at: NotRequired[datetime]
    r"""The time the target was created"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""


class TargetFlowdock(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    api_token: str

    title: str
    r"""A name for the target"""

    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""

    active: Optional[bool] = None
    r"""Whether or not the target is activated"""

    created_at: Optional[datetime] = None
    r"""The time the target was created"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class TargetEmailTypedDict(TypedDict):
    email: str
    subject: str
    title: str
    r"""A name for the target"""
    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""
    active: NotRequired[bool]
    r"""Whether or not the target is activated"""
    created_at: NotRequired[datetime]
    r"""The time the target was created"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""


class TargetEmail(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    email: str

    subject: str

    title: str
    r"""A name for the target"""

    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""

    active: Optional[bool] = None
    r"""Whether or not the target is activated"""

    created_at: Optional[datetime] = None
    r"""The time the target was created"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class TargetClickatellTypedDict(TypedDict):
    api_id: str
    password: str
    r"""only writable"""
    to: str
    username: str
    title: str
    r"""A name for the target"""
    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""
    attribute: NotRequired[str]
    r"""Read-only"""
    from_: NotRequired[str]
    method: NotRequired[str]
    r"""Read-only"""
    target_url: NotRequired[str]
    r"""Read-only"""
    us_small_business_account: NotRequired[str]
    active: NotRequired[bool]
    r"""Whether or not the target is activated"""
    created_at: NotRequired[datetime]
    r"""The time the target was created"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""


class TargetClickatell(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    api_id: str

    password: str
    r"""only writable"""

    to: str

    username: str

    title: str
    r"""A name for the target"""

    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""

    attribute: Optional[str] = None
    r"""Read-only"""

    from_: Annotated[Optional[str], pydantic.Field(alias="from")] = None

    method: Optional[str] = None
    r"""Read-only"""

    target_url: Optional[str] = None
    r"""Read-only"""

    us_small_business_account: Optional[str] = None

    active: Optional[bool] = None
    r"""Whether or not the target is activated"""

    created_at: Optional[datetime] = None
    r"""The time the target was created"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class TargetCampfireTypedDict(TypedDict):
    room: str
    subdomain: str
    token: str
    title: str
    r"""A name for the target"""
    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""
    preserve_format: NotRequired[bool]
    ssl: NotRequired[bool]
    active: NotRequired[bool]
    r"""Whether or not the target is activated"""
    created_at: NotRequired[datetime]
    r"""The time the target was created"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""


class TargetCampfire(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    room: str

    subdomain: str

    token: str

    title: str
    r"""A name for the target"""

    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""

    preserve_format: Optional[bool] = None

    ssl: Optional[bool] = None

    active: Optional[bool] = None
    r"""Whether or not the target is activated"""

    created_at: Optional[datetime] = None
    r"""The time the target was created"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class TargetBasecampTypedDict(TypedDict):
    project_id: str
    r"""The ID of the project in Basecamp where updates should be pushed"""
    resource: str
    r"""\"todo\" or \"message\" """
    target_url: str
    r"""The URL of your Basecamp account, including protocol and path"""
    token: str
    r"""Get the API token from My info > Show your tokens > Token for feed readers or the Basecamp API in your Basecamp account"""
    title: str
    r"""A name for the target"""
    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""
    message_id: NotRequired[str]
    r"""Can be filled if it is a \"message\" resource"""
    password: NotRequired[str]
    r"""The 37Signals password for the Basecamp account (only writable)"""
    todo_list_id: NotRequired[str]
    r"""Can be filled if it is a \"todo\" resource"""
    username: NotRequired[str]
    r"""The 37Signals username of the account you use to log in to Basecamp"""
    active: NotRequired[bool]
    r"""Whether or not the target is activated"""
    created_at: NotRequired[datetime]
    r"""The time the target was created"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""


class TargetBasecamp(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    project_id: str
    r"""The ID of the project in Basecamp where updates should be pushed"""

    resource: str
    r"""\"todo\" or \"message\" """

    target_url: str
    r"""The URL of your Basecamp account, including protocol and path"""

    token: str
    r"""Get the API token from My info > Show your tokens > Token for feed readers or the Basecamp API in your Basecamp account"""

    title: str
    r"""A name for the target"""

    type: str
    r"""A pre-defined target, such as \"basecamp_target\". See the additional attributes for the type that follow"""

    message_id: Optional[str] = None
    r"""Can be filled if it is a \"message\" resource"""

    password: Optional[str] = None
    r"""The 37Signals password for the Basecamp account (only writable)"""

    todo_list_id: Optional[str] = None
    r"""Can be filled if it is a \"todo\" resource"""

    username: Optional[str] = None
    r"""The 37Signals username of the account you use to log in to Basecamp"""

    active: Optional[bool] = None
    r"""Whether or not the target is activated"""

    created_at: Optional[datetime] = None
    r"""The time the target was created"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


TargetObjectTypedDict = TypeAliasType(
    "TargetObjectTypedDict",
    Union[
        TargetFlowdockTypedDict,
        TargetEmailTypedDict,
        TargetTwitterTypedDict,
        TargetYammerTypedDict,
        TargetJiraTypedDict,
        TargetGetSatisfactionTypedDict,
        TargetCampfireTypedDict,
        TargetURLTypedDict,
        TargetHTTPTypedDict,
        TargetPivotalTypedDict,
        TargetBasecampTypedDict,
        TargetClickatellTypedDict,
    ],
)


TargetObject = TypeAliasType(
    "TargetObject",
    Union[
        TargetFlowdock,
        TargetEmail,
        TargetTwitter,
        TargetYammer,
        TargetJira,
        TargetGetSatisfaction,
        TargetCampfire,
        TargetURL,
        TargetHTTP,
        TargetPivotal,
        TargetBasecamp,
        TargetClickatell,
    ],
)
