"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from enum import Enum
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class Metric(str, Enum):
    r"""The metric being tracked"""

    AGENT_WORK_TIME = "agent_work_time"
    PAUSABLE_UPDATE_TIME = "pausable_update_time"
    PERIODIC_UPDATE_TIME = "periodic_update_time"
    REPLY_TIME = "reply_time"
    REQUESTER_WAIT_TIME = "requester_wait_time"
    RESOLUTION_TIME = "resolution_time"
    GROUP_OWNERSHIP_TIME = "group_ownership_time"


class TicketMetricEventBaseObjectType(str, Enum):
    r"""The type of the metric event. See [Ticket metric event types reference](/documentation/ticketing/reference-guides/ticket-metric-event-types-reference)"""

    ACTIVATE = "activate"
    PAUSE = "pause"
    FULFILL = "fulfill"
    APPLY_SLA = "apply_sla"
    APPLY_GROUP_SLA = "apply_group_sla"
    BREACH = "breach"
    UPDATE_STATUS = "update_status"
    MEASURE = "measure"


class TicketMetricEventBaseObjectTypedDict(TypedDict):
    deleted: NotRequired[bool]
    r"""If true, the event has been deleted"""
    id: NotRequired[int]
    r"""Automatically assigned when the record is created"""
    instance_id: NotRequired[int]
    r"""The instance of the metric associated with the event. See [instance_id](#instance_id)"""
    metric: NotRequired[Metric]
    r"""The metric being tracked"""
    ticket_id: NotRequired[int]
    r"""Id of the associated ticket"""
    time: NotRequired[datetime]
    r"""The time the event occurred"""
    type: NotRequired[TicketMetricEventBaseObjectType]
    r"""The type of the metric event. See [Ticket metric event types reference](/documentation/ticketing/reference-guides/ticket-metric-event-types-reference)"""


class TicketMetricEventBaseObject(BaseModel):
    deleted: Optional[bool] = None
    r"""If true, the event has been deleted"""

    id: Optional[int] = None
    r"""Automatically assigned when the record is created"""

    instance_id: Optional[int] = None
    r"""The instance of the metric associated with the event. See [instance_id](#instance_id)"""

    metric: Optional[Metric] = None
    r"""The metric being tracked"""

    ticket_id: Optional[int] = None
    r"""Id of the associated ticket"""

    time: Optional[datetime] = None
    r"""The time the event occurred"""

    type: Optional[TicketMetricEventBaseObjectType] = None
    r"""The type of the metric event. See [Ticket metric event types reference](/documentation/ticketing/reference-guides/ticket-metric-event-types-reference)"""
