"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class AgentWaitTimeInMinutesTypedDict(TypedDict):
    r"""Number of minutes the agent spent waiting during calendar and business hours"""

    business: NotRequired[int]
    r"""Time in business hours"""
    calendar: NotRequired[int]
    r"""Time in calendar hours"""


class AgentWaitTimeInMinutes(BaseModel):
    r"""Number of minutes the agent spent waiting during calendar and business hours"""

    business: Optional[int] = None
    r"""Time in business hours"""

    calendar: Optional[int] = None
    r"""Time in calendar hours"""


class FirstResolutionTimeInMinutesTypedDict(TypedDict):
    r"""Number of minutes to the first resolution time during calendar and business hours"""

    business: NotRequired[int]
    r"""Time in business hours"""
    calendar: NotRequired[int]
    r"""Time in calendar hours"""


class FirstResolutionTimeInMinutes(BaseModel):
    r"""Number of minutes to the first resolution time during calendar and business hours"""

    business: Optional[int] = None
    r"""Time in business hours"""

    calendar: Optional[int] = None
    r"""Time in calendar hours"""


class FullResolutionTimeInMinutesTypedDict(TypedDict):
    r"""Number of minutes to the full resolution during calendar and business hours"""

    business: NotRequired[int]
    r"""Time in business hours"""
    calendar: NotRequired[int]
    r"""Time in calendar hours"""


class FullResolutionTimeInMinutes(BaseModel):
    r"""Number of minutes to the full resolution during calendar and business hours"""

    business: Optional[int] = None
    r"""Time in business hours"""

    calendar: Optional[int] = None
    r"""Time in calendar hours"""


class OnHoldTimeInMinutesTypedDict(TypedDict):
    r"""Number of minutes on hold"""

    business: NotRequired[int]
    r"""Time in business hours"""
    calendar: NotRequired[int]
    r"""Time in calendar hours"""


class OnHoldTimeInMinutes(BaseModel):
    r"""Number of minutes on hold"""

    business: Optional[int] = None
    r"""Time in business hours"""

    calendar: Optional[int] = None
    r"""Time in calendar hours"""


class ReplyTimeInMinutesTypedDict(TypedDict):
    r"""Number of minutes to the first reply during calendar and business hours"""

    business: NotRequired[int]
    r"""Time in business hours"""
    calendar: NotRequired[int]
    r"""Time in calendar hours"""


class ReplyTimeInMinutes(BaseModel):
    r"""Number of minutes to the first reply during calendar and business hours"""

    business: Optional[int] = None
    r"""Time in business hours"""

    calendar: Optional[int] = None
    r"""Time in calendar hours"""


class ReplyTimeInSecondsTypedDict(TypedDict):
    r"""Number of seconds to the first reply during calendar hours, only available for Messaging tickets"""

    business: NotRequired[int]
    r"""Time in business hours"""
    calendar: NotRequired[int]
    r"""Time in calendar hours"""


class ReplyTimeInSeconds(BaseModel):
    r"""Number of seconds to the first reply during calendar hours, only available for Messaging tickets"""

    business: Optional[int] = None
    r"""Time in business hours"""

    calendar: Optional[int] = None
    r"""Time in calendar hours"""


class RequesterWaitTimeInMinutesTypedDict(TypedDict):
    r"""Number of minutes the requester spent waiting during calendar and business hours"""

    business: NotRequired[int]
    r"""Time in business hours"""
    calendar: NotRequired[int]
    r"""Time in calendar hours"""


class RequesterWaitTimeInMinutes(BaseModel):
    r"""Number of minutes the requester spent waiting during calendar and business hours"""

    business: Optional[int] = None
    r"""Time in business hours"""

    calendar: Optional[int] = None
    r"""Time in calendar hours"""


class TicketMetricObjectTypedDict(TypedDict):
    agent_wait_time_in_minutes: NotRequired[AgentWaitTimeInMinutesTypedDict]
    r"""Number of minutes the agent spent waiting during calendar and business hours"""
    assigned_at: NotRequired[datetime]
    r"""When the ticket was assigned"""
    assignee_stations: NotRequired[int]
    r"""Number of assignees the ticket had"""
    assignee_updated_at: NotRequired[datetime]
    r"""When the assignee last updated the ticket"""
    created_at: NotRequired[datetime]
    r"""When the record was created"""
    custom_status_updated_at: NotRequired[datetime]
    r"""The date and time the ticket's custom status was last updated"""
    first_resolution_time_in_minutes: NotRequired[FirstResolutionTimeInMinutesTypedDict]
    r"""Number of minutes to the first resolution time during calendar and business hours"""
    full_resolution_time_in_minutes: NotRequired[FullResolutionTimeInMinutesTypedDict]
    r"""Number of minutes to the full resolution during calendar and business hours"""
    group_stations: NotRequired[int]
    r"""Number of groups the ticket passed through"""
    id: NotRequired[int]
    r"""Automatically assigned when the client is created"""
    initially_assigned_at: NotRequired[datetime]
    r"""When the ticket was initially assigned"""
    latest_comment_added_at: NotRequired[datetime]
    r"""When the latest comment was added"""
    on_hold_time_in_minutes: NotRequired[OnHoldTimeInMinutesTypedDict]
    r"""Number of minutes on hold"""
    reopens: NotRequired[int]
    r"""Total number of times the ticket was reopened"""
    replies: NotRequired[int]
    r"""The number of public replies added to a ticket by an agent"""
    reply_time_in_minutes: NotRequired[ReplyTimeInMinutesTypedDict]
    r"""Number of minutes to the first reply during calendar and business hours"""
    reply_time_in_seconds: NotRequired[ReplyTimeInSecondsTypedDict]
    r"""Number of seconds to the first reply during calendar hours, only available for Messaging tickets"""
    requester_updated_at: NotRequired[datetime]
    r"""When the requester last updated the ticket"""
    requester_wait_time_in_minutes: NotRequired[RequesterWaitTimeInMinutesTypedDict]
    r"""Number of minutes the requester spent waiting during calendar and business hours"""
    solved_at: NotRequired[datetime]
    r"""When the ticket was solved"""
    status_updated_at: NotRequired[datetime]
    r"""When the status of the ticket was last updated"""
    ticket_id: NotRequired[int]
    r"""Id of the associated ticket"""
    updated_at: NotRequired[datetime]
    r"""When the record was last updated"""
    url: NotRequired[str]
    r"""The API url of the ticket metric"""


class TicketMetricObject(BaseModel):
    agent_wait_time_in_minutes: Optional[AgentWaitTimeInMinutes] = None
    r"""Number of minutes the agent spent waiting during calendar and business hours"""

    assigned_at: Optional[datetime] = None
    r"""When the ticket was assigned"""

    assignee_stations: Optional[int] = None
    r"""Number of assignees the ticket had"""

    assignee_updated_at: Optional[datetime] = None
    r"""When the assignee last updated the ticket"""

    created_at: Optional[datetime] = None
    r"""When the record was created"""

    custom_status_updated_at: Optional[datetime] = None
    r"""The date and time the ticket's custom status was last updated"""

    first_resolution_time_in_minutes: Optional[FirstResolutionTimeInMinutes] = None
    r"""Number of minutes to the first resolution time during calendar and business hours"""

    full_resolution_time_in_minutes: Optional[FullResolutionTimeInMinutes] = None
    r"""Number of minutes to the full resolution during calendar and business hours"""

    group_stations: Optional[int] = None
    r"""Number of groups the ticket passed through"""

    id: Optional[int] = None
    r"""Automatically assigned when the client is created"""

    initially_assigned_at: Optional[datetime] = None
    r"""When the ticket was initially assigned"""

    latest_comment_added_at: Optional[datetime] = None
    r"""When the latest comment was added"""

    on_hold_time_in_minutes: Optional[OnHoldTimeInMinutes] = None
    r"""Number of minutes on hold"""

    reopens: Optional[int] = None
    r"""Total number of times the ticket was reopened"""

    replies: Optional[int] = None
    r"""The number of public replies added to a ticket by an agent"""

    reply_time_in_minutes: Optional[ReplyTimeInMinutes] = None
    r"""Number of minutes to the first reply during calendar and business hours"""

    reply_time_in_seconds: Optional[ReplyTimeInSeconds] = None
    r"""Number of seconds to the first reply during calendar hours, only available for Messaging tickets"""

    requester_updated_at: Optional[datetime] = None
    r"""When the requester last updated the ticket"""

    requester_wait_time_in_minutes: Optional[RequesterWaitTimeInMinutes] = None
    r"""Number of minutes the requester spent waiting during calendar and business hours"""

    solved_at: Optional[datetime] = None
    r"""When the ticket was solved"""

    status_updated_at: Optional[datetime] = None
    r"""When the status of the ticket was last updated"""

    ticket_id: Optional[int] = None
    r"""Id of the associated ticket"""

    updated_at: Optional[datetime] = None
    r"""When the record was last updated"""

    url: Optional[str] = None
    r"""The API url of the ticket metric"""
