"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .collaboratorobject import CollaboratorObject, CollaboratorObjectTypedDict
from .customfieldobject import CustomFieldObject, CustomFieldObjectTypedDict
from .emailccobject import EmailCCObject, EmailCCObjectTypedDict
from .followerobject import FollowerObject, FollowerObjectTypedDict
from .ticketcommentobject_input import (
    TicketCommentObjectInput,
    TicketCommentObjectInputTypedDict,
)
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class TicketUpdateInputPriority(str, Enum):
    r"""The urgency with which the ticket should be addressed."""

    URGENT = "urgent"
    HIGH = "high"
    NORMAL = "normal"
    LOW = "low"


class TicketUpdateInputStatus(str, Enum):
    r"""The state of the ticket.

    If your account has activated custom ticket statuses, this is the ticket's
    status category. See [custom ticket statuses](#custom-ticket-statuses).

    """

    NEW = "new"
    OPEN = "open"
    PENDING = "pending"
    HOLD = "hold"
    SOLVED = "solved"
    CLOSED = "closed"


class TicketUpdateInputType(str, Enum):
    r"""The type of this ticket."""

    PROBLEM = "problem"
    INCIDENT = "incident"
    QUESTION = "question"
    TASK = "task"


class TicketUpdateInputTypedDict(TypedDict):
    additional_collaborators: NotRequired[List[CollaboratorObjectTypedDict]]
    r"""An array of numeric IDs, emails, or objects containing name and email properties. See [Setting Collaborators](/api-reference/ticketing/tickets/tickets/#setting-collaborators). An email notification is sent to them when the ticket is updated"""
    assignee_email: NotRequired[str]
    r"""The email address of the agent to assign the ticket to"""
    assignee_id: NotRequired[int]
    r"""The agent currently assigned to the ticket"""
    attribute_value_ids: NotRequired[List[int]]
    r"""An array of the IDs of attribute values to be associated with the ticket"""
    collaborator_ids: NotRequired[List[int]]
    r"""The ids of users currently CC'ed on the ticket"""
    comment: NotRequired[TicketCommentObjectInputTypedDict]
    custom_fields: NotRequired[List[CustomFieldObjectTypedDict]]
    r"""Custom fields for the ticket. See [Setting custom field values](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-custom-field-values)"""
    custom_status_id: NotRequired[int]
    r"""The custom ticket status id of the ticket. See [custom ticket statuses](#custom-ticket-statuses)"""
    due_at: NotRequired[Nullable[datetime]]
    r"""If this is a ticket of type \"task\" it has a due date.  Due date format uses [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format."""
    email_ccs: NotRequired[List[EmailCCObjectTypedDict]]
    r"""An array of objects that represent agent or end users email CCs to add or delete from the ticket. See [Setting email CCs](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-email-ccs)"""
    external_id: NotRequired[str]
    r"""An id you can use to link Zendesk Support tickets to local records"""
    followers: NotRequired[List[FollowerObjectTypedDict]]
    r"""An array of objects that represent agent followers to add or delete from the ticket. See [Setting followers](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-followers)"""
    group_id: NotRequired[int]
    r"""The group this ticket is assigned to"""
    organization_id: NotRequired[int]
    r"""The organization of the requester. You can only specify the ID of an organization associated with the requester. See [Organization Memberships](/api-reference/ticketing/organizations/organization_memberships/)"""
    priority: NotRequired[TicketUpdateInputPriority]
    r"""The urgency with which the ticket should be addressed."""
    problem_id: NotRequired[int]
    r"""For tickets of type \"incident\", the ID of the problem the incident is linked to"""
    requester_id: NotRequired[int]
    r"""The user who requested this ticket"""
    safe_update: NotRequired[bool]
    r"""Optional boolean. Prevents updates with outdated ticket data (`updated_stamp` property required when true)"""
    sharing_agreement_ids: NotRequired[List[int]]
    r"""An array of the numeric IDs of sharing agreements. Note that this replaces any existing agreements"""
    status: NotRequired[TicketUpdateInputStatus]
    r"""The state of the ticket.

    If your account has activated custom ticket statuses, this is the ticket's
    status category. See [custom ticket statuses](#custom-ticket-statuses).

    """
    subject: NotRequired[str]
    r"""The value of the subject field for this ticket"""
    tags: NotRequired[List[str]]
    r"""The array of tags applied to this ticket"""
    type: NotRequired[TicketUpdateInputType]
    r"""The type of this ticket."""
    updated_stamp: NotRequired[datetime]
    r"""Datetime of last update received from API. See the safe_update property"""


class TicketUpdateInput(BaseModel):
    additional_collaborators: Optional[List[CollaboratorObject]] = None
    r"""An array of numeric IDs, emails, or objects containing name and email properties. See [Setting Collaborators](/api-reference/ticketing/tickets/tickets/#setting-collaborators). An email notification is sent to them when the ticket is updated"""

    assignee_email: Optional[str] = None
    r"""The email address of the agent to assign the ticket to"""

    assignee_id: Optional[int] = None
    r"""The agent currently assigned to the ticket"""

    attribute_value_ids: Optional[List[int]] = None
    r"""An array of the IDs of attribute values to be associated with the ticket"""

    collaborator_ids: Optional[List[int]] = None
    r"""The ids of users currently CC'ed on the ticket"""

    comment: Optional[TicketCommentObjectInput] = None

    custom_fields: Optional[List[CustomFieldObject]] = None
    r"""Custom fields for the ticket. See [Setting custom field values](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-custom-field-values)"""

    custom_status_id: Optional[int] = None
    r"""The custom ticket status id of the ticket. See [custom ticket statuses](#custom-ticket-statuses)"""

    due_at: OptionalNullable[datetime] = UNSET
    r"""If this is a ticket of type \"task\" it has a due date.  Due date format uses [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format."""

    email_ccs: Optional[List[EmailCCObject]] = None
    r"""An array of objects that represent agent or end users email CCs to add or delete from the ticket. See [Setting email CCs](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-email-ccs)"""

    external_id: Optional[str] = None
    r"""An id you can use to link Zendesk Support tickets to local records"""

    followers: Optional[List[FollowerObject]] = None
    r"""An array of objects that represent agent followers to add or delete from the ticket. See [Setting followers](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-followers)"""

    group_id: Optional[int] = None
    r"""The group this ticket is assigned to"""

    organization_id: Optional[int] = None
    r"""The organization of the requester. You can only specify the ID of an organization associated with the requester. See [Organization Memberships](/api-reference/ticketing/organizations/organization_memberships/)"""

    priority: Optional[TicketUpdateInputPriority] = None
    r"""The urgency with which the ticket should be addressed."""

    problem_id: Optional[int] = None
    r"""For tickets of type \"incident\", the ID of the problem the incident is linked to"""

    requester_id: Optional[int] = None
    r"""The user who requested this ticket"""

    safe_update: Optional[bool] = None
    r"""Optional boolean. Prevents updates with outdated ticket data (`updated_stamp` property required when true)"""

    sharing_agreement_ids: Optional[List[int]] = None
    r"""An array of the numeric IDs of sharing agreements. Note that this replaces any existing agreements"""

    status: Optional[TicketUpdateInputStatus] = None
    r"""The state of the ticket.

    If your account has activated custom ticket statuses, this is the ticket's
    status category. See [custom ticket statuses](#custom-ticket-statuses).

    """

    subject: Optional[str] = None
    r"""The value of the subject field for this ticket"""

    tags: Optional[List[str]] = None
    r"""The array of tags applied to this ticket"""

    type: Optional[TicketUpdateInputType] = None
    r"""The type of this ticket."""

    updated_stamp: Optional[datetime] = None
    r"""Datetime of last update received from API. See the safe_update property"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "additional_collaborators",
            "assignee_email",
            "assignee_id",
            "attribute_value_ids",
            "collaborator_ids",
            "comment",
            "custom_fields",
            "custom_status_id",
            "due_at",
            "email_ccs",
            "external_id",
            "followers",
            "group_id",
            "organization_id",
            "priority",
            "problem_id",
            "requester_id",
            "safe_update",
            "sharing_agreement_ids",
            "status",
            "subject",
            "tags",
            "type",
            "updated_stamp",
        ]
        nullable_fields = ["due_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
