"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .triggeractionobject import TriggerActionObject, TriggerActionObjectTypedDict
from .triggerconditionsobject import (
    TriggerConditionsObject,
    TriggerConditionsObjectTypedDict,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class TriggerSnapshotObjectTypedDict(TypedDict):
    actions: NotRequired[List[TriggerActionObjectTypedDict]]
    r"""An array of [Actions](#actions) describing what the ticket trigger will do"""
    active: NotRequired[bool]
    r"""Whether the ticket trigger is active"""
    conditions: NotRequired[TriggerConditionsObjectTypedDict]
    r"""An object that describes the circumstances under which the trigger performs its actions. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""
    description: NotRequired[Nullable[str]]
    r"""The description of the ticket trigger"""
    title: NotRequired[str]
    r"""The title of the ticket trigger"""


class TriggerSnapshotObject(BaseModel):
    actions: Optional[List[TriggerActionObject]] = None
    r"""An array of [Actions](#actions) describing what the ticket trigger will do"""

    active: Optional[bool] = None
    r"""Whether the ticket trigger is active"""

    conditions: Optional[TriggerConditionsObject] = None
    r"""An object that describes the circumstances under which the trigger performs its actions. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""

    description: OptionalNullable[str] = UNSET
    r"""The description of the ticket trigger"""

    title: Optional[str] = None
    r"""The title of the ticket trigger"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["actions", "active", "conditions", "description", "title"]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
