"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .triggeractionobject import TriggerActionObject, TriggerActionObjectTypedDict
from .triggerconditionsobject import (
    TriggerConditionsObject,
    TriggerConditionsObjectTypedDict,
)
from typing import List, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel


class TriggerCategoryIDTypedDict(TypedDict):
    pass


class TriggerCategoryID(BaseModel):
    pass


TriggerCategoryIDUnionTypedDict = TypeAliasType(
    "TriggerCategoryIDUnionTypedDict", Union[TriggerCategoryIDTypedDict, str]
)


TriggerCategoryIDUnion = TypeAliasType(
    "TriggerCategoryIDUnion", Union[TriggerCategoryID, str]
)


class TriggerWithCategoryRequestTriggerCategoryTypedDict(TypedDict):
    actions: List[TriggerActionObjectTypedDict]
    r"""An array of actions describing what the ticket trigger will do. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)"""
    conditions: TriggerConditionsObjectTypedDict
    r"""An object that describes the circumstances under which the trigger performs its actions. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""
    title: str
    r"""The title of the ticket trigger"""
    name: NotRequired[str]
    position: NotRequired[int]
    r"""Position of the ticket trigger, determines the order they will execute in"""
    active: NotRequired[bool]
    r"""Whether the ticket trigger is active"""
    category_id: NotRequired[str]
    r"""The ID of the category the ticket trigger belongs to"""
    description: NotRequired[str]
    r"""The description of the ticket trigger"""
    raw_title: NotRequired[str]
    r"""The raw format of the title of the ticket trigger"""


class TriggerWithCategoryRequestTriggerCategory(BaseModel):
    actions: List[TriggerActionObject]
    r"""An array of actions describing what the ticket trigger will do. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)"""

    conditions: TriggerConditionsObject
    r"""An object that describes the circumstances under which the trigger performs its actions. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""

    title: str
    r"""The title of the ticket trigger"""

    name: Optional[str] = None

    position: Optional[int] = None
    r"""Position of the ticket trigger, determines the order they will execute in"""

    active: Optional[bool] = None
    r"""Whether the ticket trigger is active"""

    category_id: Optional[str] = None
    r"""The ID of the category the ticket trigger belongs to"""

    description: Optional[str] = None
    r"""The description of the ticket trigger"""

    raw_title: Optional[str] = None
    r"""The raw format of the title of the ticket trigger"""


TriggerTypedDict = TypeAliasType(
    "TriggerTypedDict",
    Union[
        TriggerWithCategoryRequestTriggerCategoryTypedDict,
        TriggerCategoryIDUnionTypedDict,
    ],
)


Trigger = TypeAliasType(
    "Trigger", Union[TriggerWithCategoryRequestTriggerCategory, TriggerCategoryIDUnion]
)


class TriggerWithCategoryRequestTypedDict(TypedDict):
    trigger: NotRequired[TriggerTypedDict]


class TriggerWithCategoryRequest(BaseModel):
    trigger: Optional[Trigger] = None
