"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .userinput import UserInput, UserInputTypedDict
import pydantic
from pydantic import ConfigDict
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata, RequestMetadata


class UpdateManyUsersUsersRequestTypedDict(TypedDict):
    users: List[UserInputTypedDict]


class UpdateManyUsersUsersRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    users: List[UserInput]

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class UpdateManyUsersUserRequestTypedDict(TypedDict):
    user: UserInputTypedDict


class UpdateManyUsersUserRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    user: UserInput

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


UpdateManyUsersRequestBodyTypedDict = TypeAliasType(
    "UpdateManyUsersRequestBodyTypedDict",
    Union[UpdateManyUsersUserRequestTypedDict, UpdateManyUsersUsersRequestTypedDict],
)


UpdateManyUsersRequestBody = TypeAliasType(
    "UpdateManyUsersRequestBody",
    Union[UpdateManyUsersUserRequest, UpdateManyUsersUsersRequest],
)


class UpdateManyUsersRequestTypedDict(TypedDict):
    request_body: UpdateManyUsersRequestBodyTypedDict
    ids: NotRequired[str]
    r"""Id of the users to update. Comma separated"""
    external_ids: NotRequired[str]
    r"""External Id of the users to update. Comma separated"""


class UpdateManyUsersRequest(BaseModel):
    request_body: Annotated[
        UpdateManyUsersRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    ids: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Id of the users to update. Comma separated"""

    external_ids: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""External Id of the users to update. Comma separated"""
