"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from pydantic import ConfigDict, model_serializer
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class FromTypedDict(TypedDict):
    address: NotRequired[Nullable[str]]
    id: NotRequired[Nullable[int]]
    name: NotRequired[Nullable[str]]
    title: NotRequired[Nullable[str]]


class From(BaseModel):
    address: OptionalNullable[str] = UNSET

    id: OptionalNullable[int] = UNSET

    name: OptionalNullable[str] = UNSET

    title: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["address", "id", "name", "title"]
        nullable_fields = ["address", "id", "name", "title"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ToTypedDict(TypedDict):
    address: NotRequired[str]
    name: NotRequired[str]


class To(BaseModel):
    address: Optional[str] = None

    name: Optional[str] = None


class ViaObjectSourceTypedDict(TypedDict):
    r"""For some channels a source object gives more information about how or why the ticket or event was created"""

    from_: NotRequired[FromTypedDict]
    rel: NotRequired[Nullable[str]]
    to: NotRequired[ToTypedDict]


class ViaObjectSource(BaseModel):
    r"""For some channels a source object gives more information about how or why the ticket or event was created"""

    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    from_: Annotated[Optional[From], pydantic.Field(alias="from")] = None

    rel: OptionalNullable[str] = UNSET

    to: Optional[To] = None

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "rel", "to"]
        nullable_fields = ["rel"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        for k, v in serialized.items():
            m[k] = v

        return m


class ViaObjectTypedDict(TypedDict):
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)"""

    channel: NotRequired[str]
    r"""This tells you how the ticket or event was created. Examples: \"web\", \"mobile\", \"rule\", \"system\" 

    """
    source: NotRequired[ViaObjectSourceTypedDict]
    r"""For some channels a source object gives more information about how or why the ticket or event was created

    """


class ViaObject(BaseModel):
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)"""

    channel: Optional[str] = None
    r"""This tells you how the ticket or event was created. Examples: \"web\", \"mobile\", \"rule\", \"system\" 

    """

    source: Optional[ViaObjectSource] = None
    r"""For some channels a source object gives more information about how or why the ticket or event was created

    """
