"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .webhookauthentication import WebhookAuthentication, WebhookAuthenticationTypedDict
from .webhooksigningsecret import WebhookSigningSecret, WebhookSigningSecretTypedDict
from datetime import datetime
from enum import Enum
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class HTTPMethod(str, Enum):
    r"""HTTP method used for the webhook's requests. To subscribe the webhook to Zendesk events, this must be \"POST\" """

    GET = "GET"
    POST = "POST"
    PUT = "PUT"
    PATCH = "PATCH"
    DELETE = "DELETE"


class RequestFormat(str, Enum):
    r"""The format of the data that the webhook will send. To subscribe the webhook to Zendesk events, this must be \"json\" """

    JSON = "json"
    XML = "xml"
    FORM_ENCODED = "form_encoded"


class WebhookStatus(str, Enum):
    r"""Current status of the webhook"""

    ACTIVE = "active"
    INACTIVE = "inactive"


class ExternalSourceTypedDict(TypedDict):
    r"""External source by which a webhook is created, e.g. Zendesk Marketplace"""


class ExternalSource(BaseModel):
    r"""External source by which a webhook is created, e.g. Zendesk Marketplace"""


class WebhookTypedDict(TypedDict):
    name: str
    r"""Webhook name"""
    endpoint: str
    r"""The destination URL that the webhook notifies when Zendesk events occur"""
    http_method: HTTPMethod
    r"""HTTP method used for the webhook's requests. To subscribe the webhook to Zendesk events, this must be \"POST\" """
    request_format: RequestFormat
    r"""The format of the data that the webhook will send. To subscribe the webhook to Zendesk events, this must be \"json\" """
    status: WebhookStatus
    r"""Current status of the webhook"""
    id: NotRequired[str]
    r"""An auto-generated webhook id"""
    description: NotRequired[str]
    r"""Webhook description"""
    subscriptions: NotRequired[List[str]]
    r"""Event subscriptions for the webhook. To subscribe the webhook to Zendesk events, specify one or more event types"""
    authentication: NotRequired[WebhookAuthenticationTypedDict]
    r"""Adds authentication to the webhook's HTTP requests"""
    custom_headers: NotRequired[Dict[str, str]]
    r"""Custom headers to deliver additional non-credential info to destinations"""
    signing_secret: NotRequired[WebhookSigningSecretTypedDict]
    r"""Signing secret used to verify webhook requests"""
    external_source: NotRequired[ExternalSourceTypedDict]
    r"""External source by which a webhook is created, e.g. Zendesk Marketplace"""
    created_at: NotRequired[datetime]
    r"""When the webhook was created"""
    created_by: NotRequired[str]
    r"""id of the user who created the webhook. \"-1\" represents the Zendesk system"""
    updated_at: NotRequired[datetime]
    r"""When the webhook was last updated"""
    updated_by: NotRequired[str]
    r"""id of the user who last updated the webhook"""


class Webhook(BaseModel):
    name: str
    r"""Webhook name"""

    endpoint: str
    r"""The destination URL that the webhook notifies when Zendesk events occur"""

    http_method: HTTPMethod
    r"""HTTP method used for the webhook's requests. To subscribe the webhook to Zendesk events, this must be \"POST\" """

    request_format: RequestFormat
    r"""The format of the data that the webhook will send. To subscribe the webhook to Zendesk events, this must be \"json\" """

    status: WebhookStatus
    r"""Current status of the webhook"""

    id: Optional[str] = None
    r"""An auto-generated webhook id"""

    description: Optional[str] = None
    r"""Webhook description"""

    subscriptions: Optional[List[str]] = None
    r"""Event subscriptions for the webhook. To subscribe the webhook to Zendesk events, specify one or more event types"""

    authentication: Optional[WebhookAuthentication] = None
    r"""Adds authentication to the webhook's HTTP requests"""

    custom_headers: Optional[Dict[str, str]] = None
    r"""Custom headers to deliver additional non-credential info to destinations"""

    signing_secret: Optional[WebhookSigningSecret] = None
    r"""Signing secret used to verify webhook requests"""

    external_source: Optional[ExternalSource] = None
    r"""External source by which a webhook is created, e.g. Zendesk Marketplace"""

    created_at: Optional[datetime] = None
    r"""When the webhook was created"""

    created_by: Optional[str] = None
    r"""id of the user who created the webhook. \"-1\" represents the Zendesk system"""

    updated_at: Optional[datetime] = None
    r"""When the webhook was last updated"""

    updated_by: Optional[str] = None
    r"""id of the user who last updated the webhook"""


class WebhookInputTypedDict(TypedDict):
    name: str
    r"""Webhook name"""
    endpoint: str
    r"""The destination URL that the webhook notifies when Zendesk events occur"""
    http_method: HTTPMethod
    r"""HTTP method used for the webhook's requests. To subscribe the webhook to Zendesk events, this must be \"POST\" """
    request_format: RequestFormat
    r"""The format of the data that the webhook will send. To subscribe the webhook to Zendesk events, this must be \"json\" """
    status: WebhookStatus
    r"""Current status of the webhook"""
    description: NotRequired[str]
    r"""Webhook description"""
    subscriptions: NotRequired[List[str]]
    r"""Event subscriptions for the webhook. To subscribe the webhook to Zendesk events, specify one or more event types"""
    authentication: NotRequired[WebhookAuthenticationTypedDict]
    r"""Adds authentication to the webhook's HTTP requests"""
    custom_headers: NotRequired[Dict[str, str]]
    r"""Custom headers to deliver additional non-credential info to destinations"""
    signing_secret: NotRequired[WebhookSigningSecretTypedDict]
    r"""Signing secret used to verify webhook requests"""
    external_source: NotRequired[ExternalSourceTypedDict]
    r"""External source by which a webhook is created, e.g. Zendesk Marketplace"""


class WebhookInput(BaseModel):
    name: str
    r"""Webhook name"""

    endpoint: str
    r"""The destination URL that the webhook notifies when Zendesk events occur"""

    http_method: HTTPMethod
    r"""HTTP method used for the webhook's requests. To subscribe the webhook to Zendesk events, this must be \"POST\" """

    request_format: RequestFormat
    r"""The format of the data that the webhook will send. To subscribe the webhook to Zendesk events, this must be \"json\" """

    status: WebhookStatus
    r"""Current status of the webhook"""

    description: Optional[str] = None
    r"""Webhook description"""

    subscriptions: Optional[List[str]] = None
    r"""Event subscriptions for the webhook. To subscribe the webhook to Zendesk events, specify one or more event types"""

    authentication: Optional[WebhookAuthentication] = None
    r"""Adds authentication to the webhook's HTTP requests"""

    custom_headers: Optional[Dict[str, str]] = None
    r"""Custom headers to deliver additional non-credential info to destinations"""

    signing_secret: Optional[WebhookSigningSecret] = None
    r"""Signing secret used to verify webhook requests"""

    external_source: Optional[ExternalSource] = None
    r"""External source by which a webhook is created, e.g. Zendesk Marketplace"""
