"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class WebhookAuthenticationType(str, Enum):
    BASIC_AUTH = "basic_auth"
    BEARER_TOKEN = "bearer_token"
    API_KEY = "api_key"


class DataTypedDict(TypedDict):
    r"""Authentication data specific to the type"""


class Data(BaseModel):
    r"""Authentication data specific to the type"""


class AddPosition(str, Enum):
    r"""Where to add the authentication (for API key type)"""

    HEADER = "header"
    QUERY_STRING = "query_string"


class WebhookAuthenticationTypedDict(TypedDict):
    r"""Adds authentication to the webhook's HTTP requests"""

    type: NotRequired[WebhookAuthenticationType]
    data: NotRequired[DataTypedDict]
    r"""Authentication data specific to the type"""
    add_position: NotRequired[AddPosition]
    r"""Where to add the authentication (for API key type)"""


class WebhookAuthentication(BaseModel):
    r"""Adds authentication to the webhook's HTTP requests"""

    type: Optional[WebhookAuthenticationType] = None

    data: Optional[Data] = None
    r"""Authentication data specific to the type"""

    add_position: Optional[AddPosition] = None
    r"""Where to add the authentication (for API key type)"""
