"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .conditionsobject import ConditionsObject, ConditionsObjectTypedDict
from .macroobject import MacroObject, MacroObjectTypedDict
from datetime import datetime
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class WorkspaceObjectTypedDict(TypedDict):
    activated: NotRequired[bool]
    r"""If true, this workspace is available for use"""
    apps: NotRequired[List[Dict[str, Any]]]
    r"""The apps associated to this workspace"""
    conditions: NotRequired[ConditionsObjectTypedDict]
    r"""An object that describes the conditions under which the automation will execute. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""
    created_at: NotRequired[datetime]
    r"""The time the workspace was created"""
    description: NotRequired[str]
    r"""User-defined description of this workspace's purpose"""
    id: NotRequired[int]
    r"""Automatically assigned upon creation"""
    macro_ids: NotRequired[List[int]]
    r"""The ids of the macros associated to this workspace"""
    macros: NotRequired[List[int]]
    r"""The ids of the macros associated to this workspace"""
    position: NotRequired[int]
    r"""Ordering of the workspace relative to other workspaces"""
    prefer_workspace_app_order: NotRequired[bool]
    r"""If true, the order of apps within the workspace will be preserved"""
    selected_macros: NotRequired[List[MacroObjectTypedDict]]
    r"""An array of the macro objects that will be used in this workspace. See [Macros](/api-reference/ticketing/business-rules/macros/)"""
    ticket_form_id: NotRequired[int]
    r"""The id of the ticket web form associated to this workspace"""
    title: NotRequired[str]
    r"""The title of the workspace"""
    updated_at: NotRequired[datetime]
    r"""The time of the last update of the workspace"""
    url: NotRequired[str]
    r"""The URL for this resource"""


class WorkspaceObject(BaseModel):
    activated: Optional[bool] = None
    r"""If true, this workspace is available for use"""

    apps: Optional[List[Dict[str, Any]]] = None
    r"""The apps associated to this workspace"""

    conditions: Optional[ConditionsObject] = None
    r"""An object that describes the conditions under which the automation will execute. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""

    created_at: Optional[datetime] = None
    r"""The time the workspace was created"""

    description: Optional[str] = None
    r"""User-defined description of this workspace's purpose"""

    id: Optional[int] = None
    r"""Automatically assigned upon creation"""

    macro_ids: Optional[List[int]] = None
    r"""The ids of the macros associated to this workspace"""

    macros: Optional[List[int]] = None
    r"""The ids of the macros associated to this workspace"""

    position: Optional[int] = None
    r"""Ordering of the workspace relative to other workspaces"""

    prefer_workspace_app_order: Optional[bool] = None
    r"""If true, the order of apps within the workspace will be preserved"""

    selected_macros: Optional[List[MacroObject]] = None
    r"""An array of the macro objects that will be used in this workspace. See [Macros](/api-reference/ticketing/business-rules/macros/)"""

    ticket_form_id: Optional[int] = None
    r"""The id of the ticket web form associated to this workspace"""

    title: Optional[str] = None
    r"""The title of the workspace"""

    updated_at: Optional[datetime] = None
    r"""The time of the last update of the workspace"""

    url: Optional[str] = None
    r"""The URL for this resource"""
