"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from jsonpath import JSONPath
from typing import Any, Dict, List, Mapping, Optional, Union
from zendesk import errors, models, utils
from zendesk._hooks import HookContext
from zendesk.types import OptionalNullable, UNSET
from zendesk.utils import get_security_from_env


class Search(BaseSDK):
    def list_search_results(
        self,
        *,
        query: str,
        sort_by: Optional[models.SortBy] = None,
        sort_order: Optional[models.SortOrder] = None,
        page: Optional[int] = 1,
        per_page: Optional[int] = 100,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListSearchResultsResponse]:
        r"""List Search Results

        Returns the search results. See [Query basics](#query-basics) for the syntax of the `query` parameter.

        Use the ampersand character (&) to append the `sort_by` or `sort_order` parameters to the URL.

        For examples, see [Searching with Zendesk API](/documentation/ticketing/using-the-zendesk-api/searching-with-the-zendesk-api).

        #### Allowed For

        * Agents

        #### Pagination

        * Offset pagination only

        Offset pagination may result in duplicate results when paging. You can also use the
        [Export Search Results](/api-reference/ticketing/ticket-management/search/#export-search-results) endpoint, which
        uses cursor-based pagination and doesn't return duplicate results. See
        [Using cursor pagination](/api-reference/introduction/pagination/#using-cursor-pagination) for more information.


        #### Errors JSON Format

        Errors are represented as JSON objects which have the following keys:

        | Name                  | Type                 | Comment
        | --------------------- | ---------------------| --------------------
        | error                 | string               | The type of error. Examples: \"unavailable\", \"invalid\"
        | description           | string               |

        ##### Example Error
        ```js
        {
        \"error\": \"unavailable\",
        \"description\": \"Sorry, we could not complete your search query. Please try again in a moment.\"
        }
        ```


        :param query: The search query. See [Query basics](#query-basics) above. For details on the query syntax, see the [Zendesk Support search reference](https://support.zendesk.com/hc/en-us/articles/203663226)
        :param sort_by: One of `updated_at`, `created_at`, `priority`, `status`, or `ticket_type`. Defaults to sorting by relevance
        :param sort_order: One of `asc` or `desc`.  Defaults to `desc`
        :param page: Page number for offset pagination
        :param per_page: Number of items per page
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListSearchResultsRequest(
            query=query,
            sort_by=sort_by,
            sort_order=sort_order,
            page=page,
            per_page=per_page,
        )

        req = self._build_request(
            method="GET",
            path="/api/v2/search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="ListSearchResults",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListSearchResultsResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            page = request.page if not request.page is None else 1
            next_page = page + 1

            if not http_res.text:
                return None
            results = JSONPath("$.results").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.per_page if not request.per_page is None else 100
            if len(results[0]) < limit:
                return None

            return self.list_search_results(
                query=query,
                sort_by=sort_by,
                sort_order=sort_order,
                page=next_page,
                per_page=per_page,
                retries=retries,
            )

        if utils.match_response(http_res, "200", "application/json"):
            return models.ListSearchResultsResponse(
                result=utils.unmarshal_json(http_res.text, models.SearchResponse),
                next=next_func,
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def list_search_results_async(
        self,
        *,
        query: str,
        sort_by: Optional[models.SortBy] = None,
        sort_order: Optional[models.SortOrder] = None,
        page: Optional[int] = 1,
        per_page: Optional[int] = 100,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListSearchResultsResponse]:
        r"""List Search Results

        Returns the search results. See [Query basics](#query-basics) for the syntax of the `query` parameter.

        Use the ampersand character (&) to append the `sort_by` or `sort_order` parameters to the URL.

        For examples, see [Searching with Zendesk API](/documentation/ticketing/using-the-zendesk-api/searching-with-the-zendesk-api).

        #### Allowed For

        * Agents

        #### Pagination

        * Offset pagination only

        Offset pagination may result in duplicate results when paging. You can also use the
        [Export Search Results](/api-reference/ticketing/ticket-management/search/#export-search-results) endpoint, which
        uses cursor-based pagination and doesn't return duplicate results. See
        [Using cursor pagination](/api-reference/introduction/pagination/#using-cursor-pagination) for more information.


        #### Errors JSON Format

        Errors are represented as JSON objects which have the following keys:

        | Name                  | Type                 | Comment
        | --------------------- | ---------------------| --------------------
        | error                 | string               | The type of error. Examples: \"unavailable\", \"invalid\"
        | description           | string               |

        ##### Example Error
        ```js
        {
        \"error\": \"unavailable\",
        \"description\": \"Sorry, we could not complete your search query. Please try again in a moment.\"
        }
        ```


        :param query: The search query. See [Query basics](#query-basics) above. For details on the query syntax, see the [Zendesk Support search reference](https://support.zendesk.com/hc/en-us/articles/203663226)
        :param sort_by: One of `updated_at`, `created_at`, `priority`, `status`, or `ticket_type`. Defaults to sorting by relevance
        :param sort_order: One of `asc` or `desc`.  Defaults to `desc`
        :param page: Page number for offset pagination
        :param per_page: Number of items per page
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListSearchResultsRequest(
            query=query,
            sort_by=sort_by,
            sort_order=sort_order,
            page=page,
            per_page=per_page,
        )

        req = self._build_request_async(
            method="GET",
            path="/api/v2/search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="ListSearchResults",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListSearchResultsResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            page = request.page if not request.page is None else 1
            next_page = page + 1

            if not http_res.text:
                return None
            results = JSONPath("$.results").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.per_page if not request.per_page is None else 100
            if len(results[0]) < limit:
                return None

            return self.list_search_results(
                query=query,
                sort_by=sort_by,
                sort_order=sort_order,
                page=next_page,
                per_page=per_page,
                retries=retries,
            )

        if utils.match_response(http_res, "200", "application/json"):
            return models.ListSearchResultsResponse(
                result=utils.unmarshal_json(http_res.text, models.SearchResponse),
                next=next_func,
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def count_search_results(
        self,
        *,
        query: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SearchCountResponse:
        r"""Show Results Count

        Returns the number of items matching the query rather than the items. The search string works the same as a regular search.

        #### Allowed For

        - Agents


        :param query: The search query
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CountSearchResultsRequest(
            query=query,
        )

        req = self._build_request(
            method="GET",
            path="/api/v2/search/count",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="CountSearchResults",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.SearchCountResponse)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def count_search_results_async(
        self,
        *,
        query: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SearchCountResponse:
        r"""Show Results Count

        Returns the number of items matching the query rather than the items. The search string works the same as a regular search.

        #### Allowed For

        - Agents


        :param query: The search query
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CountSearchResultsRequest(
            query=query,
        )

        req = self._build_request_async(
            method="GET",
            path="/api/v2/search/count",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="CountSearchResults",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(http_res.text, models.SearchCountResponse)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def export_search_results(
        self,
        *,
        query: str,
        page_before: Optional[str] = None,
        page_after: Optional[str] = None,
        page_size: Optional[int] = 100,
        filter_type: Optional[models.FilterType] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ExportSearchResultsResponse]:
        r"""Export Search Results

        Exports a set of results. See [Query syntax](#query-syntax) for the syntax of the `query` parameter.

        Use this endpoint for search queries that will return more than 1000 results. The result set is ordered only by the `created_at` attribute.

        The search only returns results of a single object type. The following object types are supported: ticket, organization, user, or group.

        You must specify the type in the `filter[type]` parameter. Searches with type in the query string will result in an error.

        #### Allowed For

        - Agents

        #### Pagination

        - Cursor pagination

        See [Pagination](/api-reference/introduction/pagination/).

        Returns a maximum of 1000 records per page. The number of results shown in a page is determined by the `page[size]` parameter.

        **Note**: You may experience a speed reduction or a timeout if you request 1000 results per page and you have many archived tickets in the results. Try reducing the number of results per page. We recommend 100 results per page.

        The cursor specified by the `after_cursor` property in a response expires after one hour.

        For more information on cursor-based pagination, see the following articles:

        - [Comparing cursor pagination and offset pagination](/documentation/developer-tools/pagination/comparing-cursor-pagination-and-offset-pagination)
        - [Paginating through lists using cursor pagination](/documentation/developer-tools/pagination/paginating-through-lists-using-cursor-pagination)

        #### Limits

        This API endpoint is rate-limited to 100 requests per minute per account. The limit also counts towards the global API rate limit.

        #### Response Format

        | Name                  | Type                 | Comment
        | --------------------- | ---------------------| --------------------
        | links[next]           | string               | URL to the next page of results
        | meta[has_more]        | string               | Boolean indicating if there are more results
        | meta[after_cursor]    | string               | Cursor object returned from the Search Service
        | results               | array                | May consist of tickets, users, groups, or organizations, as specified by the `filter_type` parameter

        The response is similar to the response of `GET /api/v2/search.json?`, with a few changes:

        * `links` - Has the following nested properties: `prev` and `next`. These replace the `next_page` and `prev_page` links. The `prev` property is always null because backward pagination is not supported. The `next` property may include an auto-generated link to the next page of results.
        * `meta` - Has the following nested properties: `has_more` and `after_cursor`. The `has_more` property indicates whether the next page has more results. The `after_cursor` property is the cursor used to paginate to the next page. It expires after one hour.

        There's no `count` property.


        :param query: The search query. See [Query basics](#query-basics) above. For details on the query syntax, see the [Zendesk Support search reference](https://support.zendesk.com/hc/en-us/articles/203663226)
        :param page_before: A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.
        :param page_after: A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.
        :param page_size: Specifies how many records should be returned in the response. You can specify up to 100 records per page.
        :param filter_type: The object type returned by the export query. Can be `ticket`, `organization`, `user`, or `group`.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ExportSearchResultsRequest(
            page_before=page_before,
            page_after=page_after,
            page_size=page_size,
            query=query,
            filter_type=filter_type,
        )

        req = self._build_request(
            method="GET",
            path="/api/v2/search/export",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="ExportSearchResults",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ExportSearchResultsResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.meta.after_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None:
                return None

            return self.export_search_results(
                query=query,
                page_before=page_before,
                page_after=next_cursor,
                page_size=page_size,
                filter_type=filter_type,
                retries=retries,
            )

        if utils.match_response(http_res, "200", "application/json"):
            return models.ExportSearchResultsResponse(
                result=utils.unmarshal_json(http_res.text, models.SearchExportResponse),
                next=next_func,
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def export_search_results_async(
        self,
        *,
        query: str,
        page_before: Optional[str] = None,
        page_after: Optional[str] = None,
        page_size: Optional[int] = 100,
        filter_type: Optional[models.FilterType] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ExportSearchResultsResponse]:
        r"""Export Search Results

        Exports a set of results. See [Query syntax](#query-syntax) for the syntax of the `query` parameter.

        Use this endpoint for search queries that will return more than 1000 results. The result set is ordered only by the `created_at` attribute.

        The search only returns results of a single object type. The following object types are supported: ticket, organization, user, or group.

        You must specify the type in the `filter[type]` parameter. Searches with type in the query string will result in an error.

        #### Allowed For

        - Agents

        #### Pagination

        - Cursor pagination

        See [Pagination](/api-reference/introduction/pagination/).

        Returns a maximum of 1000 records per page. The number of results shown in a page is determined by the `page[size]` parameter.

        **Note**: You may experience a speed reduction or a timeout if you request 1000 results per page and you have many archived tickets in the results. Try reducing the number of results per page. We recommend 100 results per page.

        The cursor specified by the `after_cursor` property in a response expires after one hour.

        For more information on cursor-based pagination, see the following articles:

        - [Comparing cursor pagination and offset pagination](/documentation/developer-tools/pagination/comparing-cursor-pagination-and-offset-pagination)
        - [Paginating through lists using cursor pagination](/documentation/developer-tools/pagination/paginating-through-lists-using-cursor-pagination)

        #### Limits

        This API endpoint is rate-limited to 100 requests per minute per account. The limit also counts towards the global API rate limit.

        #### Response Format

        | Name                  | Type                 | Comment
        | --------------------- | ---------------------| --------------------
        | links[next]           | string               | URL to the next page of results
        | meta[has_more]        | string               | Boolean indicating if there are more results
        | meta[after_cursor]    | string               | Cursor object returned from the Search Service
        | results               | array                | May consist of tickets, users, groups, or organizations, as specified by the `filter_type` parameter

        The response is similar to the response of `GET /api/v2/search.json?`, with a few changes:

        * `links` - Has the following nested properties: `prev` and `next`. These replace the `next_page` and `prev_page` links. The `prev` property is always null because backward pagination is not supported. The `next` property may include an auto-generated link to the next page of results.
        * `meta` - Has the following nested properties: `has_more` and `after_cursor`. The `has_more` property indicates whether the next page has more results. The `after_cursor` property is the cursor used to paginate to the next page. It expires after one hour.

        There's no `count` property.


        :param query: The search query. See [Query basics](#query-basics) above. For details on the query syntax, see the [Zendesk Support search reference](https://support.zendesk.com/hc/en-us/articles/203663226)
        :param page_before: A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.
        :param page_after: A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.
        :param page_size: Specifies how many records should be returned in the response. You can specify up to 100 records per page.
        :param filter_type: The object type returned by the export query. Can be `ticket`, `organization`, `user`, or `group`.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ExportSearchResultsRequest(
            page_before=page_before,
            page_after=page_after,
            page_size=page_size,
            query=query,
            filter_type=filter_type,
        )

        req = self._build_request_async(
            method="GET",
            path="/api/v2/search/export",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="ExportSearchResults",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ExportSearchResultsResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.meta.after_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None:
                return None

            return self.export_search_results(
                query=query,
                page_before=page_before,
                page_after=next_cursor,
                page_size=page_size,
                filter_type=filter_type,
                retries=retries,
            )

        if utils.match_response(http_res, "200", "application/json"):
            return models.ExportSearchResultsResponse(
                result=utils.unmarshal_json(http_res.text, models.SearchExportResponse),
                next=next_func,
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
