from typing import Tuple, Dict

import numpy as np


class SKLearnPredictor:
    """
    Base class for predictors generated by scikit-learn based estimators of
    :class:`~syne_tune.optimizer.schedulers.searchers.bayesopt.sklearn.estimator.SKLearnEstimator`.

    This is only for predictors who return means and stddevs in :meth:`predict`.
    """

    def predict(self, X: np.ndarray) -> Tuple[np.ndarray, np.ndarray]:
        """
        Returns signals which are statistics of the predictive distribution at
        input points ``inputs``.

        :param inputs: Input points, shape ``(n, d)``
        :return: ``(means, stds)``, where predictive means ``means`` and
            predictive stddevs ``stds`` have shape ``(n,)``
        """
        raise NotImplementedError

    def backward_gradient(
        self, input: np.ndarray, head_gradients: Dict[str, np.ndarray]
    ) -> np.ndarray:
        r"""
        Needs to be implemented only if gradient-based local optimization of
        an acquisition function is supported.

        Computes the gradient :math:`\nabla f(x)` for an acquisition
        function :math:`f(x)`, where :math:`x` is a single input point. This
        is using reverse mode differentiation, the head gradients are passed
        by the acquisition function. The head gradients are
        :math:`\partial_k f`, where :math:`k` runs over the statistics
        returned by :meth:`predict` for the single input point :math:`x`.
        The shape of head gradients is the same as the shape of the
        statistics.

        :param input: Single input point :math:`x`, shape ``(d,)``
        :param head_gradients: See above
        :return: Gradient :math:`\nabla f(x)`
        """
        raise NotImplementedError
