import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementApiOperationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html#api_management_name ApiManagementApiOperationPolicy#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html#api_name ApiManagementApiOperationPolicy#api_name}.
     *
     * @stability stable
     */
    readonly apiName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html#operation_id ApiManagementApiOperationPolicy#operation_id}.
     *
     * @stability stable
     */
    readonly operationId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html#resource_group_name ApiManagementApiOperationPolicy#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html#xml_content ApiManagementApiOperationPolicy#xml_content}.
     *
     * @stability stable
     */
    readonly xmlContent?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html#xml_link ApiManagementApiOperationPolicy#xml_link}.
     *
     * @stability stable
     */
    readonly xmlLink?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html#timeouts ApiManagementApiOperationPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementApiOperationPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementApiOperationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html#create ApiManagementApiOperationPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html#delete ApiManagementApiOperationPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html#read ApiManagementApiOperationPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html#update ApiManagementApiOperationPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementApiOperationPolicyTimeoutsToTerraform(struct?: ApiManagementApiOperationPolicyTimeoutsOutputReference | ApiManagementApiOperationPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiOperationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiOperationPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiOperationPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html azurerm_api_management_api_operation_policy}.
 *
 * @stability stable
 */
export declare class ApiManagementApiOperationPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_policy.html azurerm_api_management_api_operation_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementApiOperationPolicyConfig);
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    private _apiName?;
    /**
     * @stability stable
     */
    get apiName(): string;
    /**
     * @stability stable
     */
    set apiName(value: string);
    /**
     * @stability stable
     */
    get apiNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _operationId?;
    /**
     * @stability stable
     */
    get operationId(): string;
    /**
     * @stability stable
     */
    set operationId(value: string);
    /**
     * @stability stable
     */
    get operationIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _xmlContent?;
    /**
     * @stability stable
     */
    get xmlContent(): string;
    /**
     * @stability stable
     */
    set xmlContent(value: string);
    /**
     * @stability stable
     */
    resetXmlContent(): void;
    /**
     * @stability stable
     */
    get xmlContentInput(): string | undefined;
    private _xmlLink?;
    /**
     * @stability stable
     */
    get xmlLink(): string;
    /**
     * @stability stable
     */
    set xmlLink(value: string);
    /**
     * @stability stable
     */
    resetXmlLink(): void;
    /**
     * @stability stable
     */
    get xmlLinkInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementApiOperationPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementApiOperationPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementApiOperationPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
