import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AutomationRunbookConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#automation_account_name AutomationRunbook#automation_account_name}.
     *
     * @stability stable
     */
    readonly automationAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#content AutomationRunbook#content}.
     *
     * @stability stable
     */
    readonly content?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#description AutomationRunbook#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#job_schedule AutomationRunbook#job_schedule}.
     *
     * @stability stable
     */
    readonly jobSchedule?: AutomationRunbookJobSchedule[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#location AutomationRunbook#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#log_progress AutomationRunbook#log_progress}.
     *
     * @stability stable
     */
    readonly logProgress: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#log_verbose AutomationRunbook#log_verbose}.
     *
     * @stability stable
     */
    readonly logVerbose: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#name AutomationRunbook#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#resource_group_name AutomationRunbook#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#runbook_type AutomationRunbook#runbook_type}.
     *
     * @stability stable
     */
    readonly runbookType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#tags AutomationRunbook#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * publish_content_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#publish_content_link AutomationRunbook#publish_content_link}
     *
     * @stability stable
     */
    readonly publishContentLink?: AutomationRunbookPublishContentLink;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#timeouts AutomationRunbook#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AutomationRunbookTimeouts;
}
/**
 * @stability stable
 */
export interface AutomationRunbookJobSchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#job_schedule_id AutomationRunbook#job_schedule_id}.
     *
     * @stability stable
     */
    readonly jobScheduleId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#parameters AutomationRunbook#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#run_on AutomationRunbook#run_on}.
     *
     * @stability stable
     */
    readonly runOn?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#schedule_name AutomationRunbook#schedule_name}.
     *
     * @stability stable
     */
    readonly scheduleName?: string;
}
export declare function automationRunbookJobScheduleToTerraform(struct?: AutomationRunbookJobSchedule): any;
/**
 * @stability stable
 */
export interface AutomationRunbookPublishContentLinkHash {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#algorithm AutomationRunbook#algorithm}.
     *
     * @stability stable
     */
    readonly algorithm: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#value AutomationRunbook#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function automationRunbookPublishContentLinkHashToTerraform(struct?: AutomationRunbookPublishContentLinkHashOutputReference | AutomationRunbookPublishContentLinkHash): any;
/**
 * @stability stable
 */
export declare class AutomationRunbookPublishContentLinkHashOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AutomationRunbookPublishContentLinkHash | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AutomationRunbookPublishContentLinkHash | undefined);
    private _algorithm?;
    /**
     * @stability stable
     */
    get algorithm(): string;
    /**
     * @stability stable
     */
    set algorithm(value: string);
    /**
     * @stability stable
     */
    get algorithmInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AutomationRunbookPublishContentLink {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#uri AutomationRunbook#uri}.
     *
     * @stability stable
     */
    readonly uri: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#version AutomationRunbook#version}.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * hash block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#hash AutomationRunbook#hash}
     *
     * @stability stable
     */
    readonly hash?: AutomationRunbookPublishContentLinkHash;
}
export declare function automationRunbookPublishContentLinkToTerraform(struct?: AutomationRunbookPublishContentLinkOutputReference | AutomationRunbookPublishContentLink): any;
/**
 * @stability stable
 */
export declare class AutomationRunbookPublishContentLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AutomationRunbookPublishContentLink | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AutomationRunbookPublishContentLink | undefined);
    private _uri?;
    /**
     * @stability stable
     */
    get uri(): string;
    /**
     * @stability stable
     */
    set uri(value: string);
    /**
     * @stability stable
     */
    get uriInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _hash;
    /**
     * @stability stable
     */
    get hash(): AutomationRunbookPublishContentLinkHashOutputReference;
    /**
     * @stability stable
     */
    putHash(value: AutomationRunbookPublishContentLinkHash): void;
    /**
     * @stability stable
     */
    resetHash(): void;
    /**
     * @stability stable
     */
    get hashInput(): AutomationRunbookPublishContentLinkHash | undefined;
}
/**
 * @stability stable
 */
export interface AutomationRunbookTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#create AutomationRunbook#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#delete AutomationRunbook#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#read AutomationRunbook#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html#update AutomationRunbook#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function automationRunbookTimeoutsToTerraform(struct?: AutomationRunbookTimeoutsOutputReference | AutomationRunbookTimeouts): any;
/**
 * @stability stable
 */
export declare class AutomationRunbookTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AutomationRunbookTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AutomationRunbookTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html azurerm_automation_runbook}.
 *
 * @stability stable
 */
export declare class AutomationRunbook extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/automation_runbook.html azurerm_automation_runbook} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AutomationRunbookConfig);
    private _automationAccountName?;
    /**
     * @stability stable
     */
    get automationAccountName(): string;
    /**
     * @stability stable
     */
    set automationAccountName(value: string);
    /**
     * @stability stable
     */
    get automationAccountNameInput(): string | undefined;
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    resetContent(): void;
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _jobSchedule?;
    /**
     * @stability stable
     */
    get jobSchedule(): AutomationRunbookJobSchedule[];
    /**
     * @stability stable
     */
    set jobSchedule(value: AutomationRunbookJobSchedule[]);
    /**
     * @stability stable
     */
    resetJobSchedule(): void;
    /**
     * @stability stable
     */
    get jobScheduleInput(): AutomationRunbookJobSchedule[] | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _logProgress?;
    /**
     * @stability stable
     */
    get logProgress(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set logProgress(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get logProgressInput(): boolean | cdktf.IResolvable | undefined;
    private _logVerbose?;
    /**
     * @stability stable
     */
    get logVerbose(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set logVerbose(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get logVerboseInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _runbookType?;
    /**
     * @stability stable
     */
    get runbookType(): string;
    /**
     * @stability stable
     */
    set runbookType(value: string);
    /**
     * @stability stable
     */
    get runbookTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _publishContentLink;
    /**
     * @stability stable
     */
    get publishContentLink(): AutomationRunbookPublishContentLinkOutputReference;
    /**
     * @stability stable
     */
    putPublishContentLink(value: AutomationRunbookPublishContentLink): void;
    /**
     * @stability stable
     */
    resetPublishContentLink(): void;
    /**
     * @stability stable
     */
    get publishContentLinkInput(): AutomationRunbookPublishContentLink | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AutomationRunbookTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AutomationRunbookTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AutomationRunbookTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
