import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CognitiveAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#custom_subdomain_name CognitiveAccount#custom_subdomain_name}.
     *
     * @stability stable
     */
    readonly customSubdomainName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#fqdns CognitiveAccount#fqdns}.
     *
     * @stability stable
     */
    readonly fqdns?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#kind CognitiveAccount#kind}.
     *
     * @stability stable
     */
    readonly kind: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#local_auth_enabled CognitiveAccount#local_auth_enabled}.
     *
     * @stability stable
     */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#location CognitiveAccount#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#metrics_advisor_aad_client_id CognitiveAccount#metrics_advisor_aad_client_id}.
     *
     * @stability stable
     */
    readonly metricsAdvisorAadClientId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#metrics_advisor_aad_tenant_id CognitiveAccount#metrics_advisor_aad_tenant_id}.
     *
     * @stability stable
     */
    readonly metricsAdvisorAadTenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#metrics_advisor_super_user_name CognitiveAccount#metrics_advisor_super_user_name}.
     *
     * @stability stable
     */
    readonly metricsAdvisorSuperUserName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#metrics_advisor_website_name CognitiveAccount#metrics_advisor_website_name}.
     *
     * @stability stable
     */
    readonly metricsAdvisorWebsiteName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#name CognitiveAccount#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#outbound_network_access_restrited CognitiveAccount#outbound_network_access_restrited}.
     *
     * @stability stable
     */
    readonly outboundNetworkAccessRestrited?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#public_network_access_enabled CognitiveAccount#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#qna_runtime_endpoint CognitiveAccount#qna_runtime_endpoint}.
     *
     * @stability stable
     */
    readonly qnaRuntimeEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#resource_group_name CognitiveAccount#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#sku_name CognitiveAccount#sku_name}.
     *
     * @stability stable
     */
    readonly skuName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#tags CognitiveAccount#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#identity CognitiveAccount#identity}
     *
     * @stability stable
     */
    readonly identity?: CognitiveAccountIdentity;
    /**
     * network_acls block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#network_acls CognitiveAccount#network_acls}
     *
     * @stability stable
     */
    readonly networkAcls?: CognitiveAccountNetworkAcls;
    /**
     * storage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#storage CognitiveAccount#storage}
     *
     * @stability stable
     */
    readonly storage?: CognitiveAccountStorage[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#timeouts CognitiveAccount#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CognitiveAccountTimeouts;
}
/**
 * @stability stable
 */
export interface CognitiveAccountIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#identity_ids CognitiveAccount#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#type CognitiveAccount#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function cognitiveAccountIdentityToTerraform(struct?: CognitiveAccountIdentityOutputReference | CognitiveAccountIdentity): any;
/**
 * @stability stable
 */
export declare class CognitiveAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CognitiveAccountIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CognitiveAccountIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CognitiveAccountNetworkAclsVirtualNetworkRules {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#ignore_missing_vnet_service_endpoint CognitiveAccount#ignore_missing_vnet_service_endpoint}.
     *
     * @stability stable
     */
    readonly ignoreMissingVnetServiceEndpoint?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#subnet_id CognitiveAccount#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
}
export declare function cognitiveAccountNetworkAclsVirtualNetworkRulesToTerraform(struct?: CognitiveAccountNetworkAclsVirtualNetworkRules): any;
/**
 * @stability stable
 */
export interface CognitiveAccountNetworkAcls {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#default_action CognitiveAccount#default_action}.
     *
     * @stability stable
     */
    readonly defaultAction: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#ip_rules CognitiveAccount#ip_rules}.
     *
     * @stability stable
     */
    readonly ipRules?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#virtual_network_rules CognitiveAccount#virtual_network_rules}.
     *
     * @stability stable
     */
    readonly virtualNetworkRules?: CognitiveAccountNetworkAclsVirtualNetworkRules[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#virtual_network_subnet_ids CognitiveAccount#virtual_network_subnet_ids}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetIds?: string[];
}
export declare function cognitiveAccountNetworkAclsToTerraform(struct?: CognitiveAccountNetworkAclsOutputReference | CognitiveAccountNetworkAcls): any;
/**
 * @stability stable
 */
export declare class CognitiveAccountNetworkAclsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CognitiveAccountNetworkAcls | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CognitiveAccountNetworkAcls | undefined);
    private _defaultAction?;
    /**
     * @stability stable
     */
    get defaultAction(): string;
    /**
     * @stability stable
     */
    set defaultAction(value: string);
    /**
     * @stability stable
     */
    get defaultActionInput(): string | undefined;
    private _ipRules?;
    /**
     * @stability stable
     */
    get ipRules(): string[];
    /**
     * @stability stable
     */
    set ipRules(value: string[]);
    /**
     * @stability stable
     */
    resetIpRules(): void;
    /**
     * @stability stable
     */
    get ipRulesInput(): string[] | undefined;
    private _virtualNetworkRules?;
    /**
     * @stability stable
     */
    get virtualNetworkRules(): CognitiveAccountNetworkAclsVirtualNetworkRules[];
    /**
     * @stability stable
     */
    set virtualNetworkRules(value: CognitiveAccountNetworkAclsVirtualNetworkRules[]);
    /**
     * @stability stable
     */
    resetVirtualNetworkRules(): void;
    /**
     * @stability stable
     */
    get virtualNetworkRulesInput(): CognitiveAccountNetworkAclsVirtualNetworkRules[] | undefined;
    private _virtualNetworkSubnetIds?;
    /**
     * @stability stable
     */
    get virtualNetworkSubnetIds(): string[];
    /**
     * @stability stable
     */
    set virtualNetworkSubnetIds(value: string[]);
    /**
     * @stability stable
     */
    resetVirtualNetworkSubnetIds(): void;
    /**
     * @stability stable
     */
    get virtualNetworkSubnetIdsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface CognitiveAccountStorage {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#identity_client_id CognitiveAccount#identity_client_id}.
     *
     * @stability stable
     */
    readonly identityClientId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#storage_account_id CognitiveAccount#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
}
export declare function cognitiveAccountStorageToTerraform(struct?: CognitiveAccountStorage): any;
/**
 * @stability stable
 */
export interface CognitiveAccountTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#create CognitiveAccount#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#delete CognitiveAccount#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#read CognitiveAccount#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html#update CognitiveAccount#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cognitiveAccountTimeoutsToTerraform(struct?: CognitiveAccountTimeoutsOutputReference | CognitiveAccountTimeouts): any;
/**
 * @stability stable
 */
export declare class CognitiveAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CognitiveAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CognitiveAccountTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html azurerm_cognitive_account}.
 *
 * @stability stable
 */
export declare class CognitiveAccount extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cognitive_account.html azurerm_cognitive_account} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CognitiveAccountConfig);
    private _customSubdomainName?;
    /**
     * @stability stable
     */
    get customSubdomainName(): string;
    /**
     * @stability stable
     */
    set customSubdomainName(value: string);
    /**
     * @stability stable
     */
    resetCustomSubdomainName(): void;
    /**
     * @stability stable
     */
    get customSubdomainNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get endpoint(): string;
    private _fqdns?;
    /**
     * @stability stable
     */
    get fqdns(): string[];
    /**
     * @stability stable
     */
    set fqdns(value: string[]);
    /**
     * @stability stable
     */
    resetFqdns(): void;
    /**
     * @stability stable
     */
    get fqdnsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _kind?;
    /**
     * @stability stable
     */
    get kind(): string;
    /**
     * @stability stable
     */
    set kind(value: string);
    /**
     * @stability stable
     */
    get kindInput(): string | undefined;
    private _localAuthEnabled?;
    /**
     * @stability stable
     */
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocalAuthEnabled(): void;
    /**
     * @stability stable
     */
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _metricsAdvisorAadClientId?;
    /**
     * @stability stable
     */
    get metricsAdvisorAadClientId(): string;
    /**
     * @stability stable
     */
    set metricsAdvisorAadClientId(value: string);
    /**
     * @stability stable
     */
    resetMetricsAdvisorAadClientId(): void;
    /**
     * @stability stable
     */
    get metricsAdvisorAadClientIdInput(): string | undefined;
    private _metricsAdvisorAadTenantId?;
    /**
     * @stability stable
     */
    get metricsAdvisorAadTenantId(): string;
    /**
     * @stability stable
     */
    set metricsAdvisorAadTenantId(value: string);
    /**
     * @stability stable
     */
    resetMetricsAdvisorAadTenantId(): void;
    /**
     * @stability stable
     */
    get metricsAdvisorAadTenantIdInput(): string | undefined;
    private _metricsAdvisorSuperUserName?;
    /**
     * @stability stable
     */
    get metricsAdvisorSuperUserName(): string;
    /**
     * @stability stable
     */
    set metricsAdvisorSuperUserName(value: string);
    /**
     * @stability stable
     */
    resetMetricsAdvisorSuperUserName(): void;
    /**
     * @stability stable
     */
    get metricsAdvisorSuperUserNameInput(): string | undefined;
    private _metricsAdvisorWebsiteName?;
    /**
     * @stability stable
     */
    get metricsAdvisorWebsiteName(): string;
    /**
     * @stability stable
     */
    set metricsAdvisorWebsiteName(value: string);
    /**
     * @stability stable
     */
    resetMetricsAdvisorWebsiteName(): void;
    /**
     * @stability stable
     */
    get metricsAdvisorWebsiteNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _outboundNetworkAccessRestrited?;
    /**
     * @stability stable
     */
    get outboundNetworkAccessRestrited(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set outboundNetworkAccessRestrited(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOutboundNetworkAccessRestrited(): void;
    /**
     * @stability stable
     */
    get outboundNetworkAccessRestritedInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get primaryAccessKey(): string;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _qnaRuntimeEndpoint?;
    /**
     * @stability stable
     */
    get qnaRuntimeEndpoint(): string;
    /**
     * @stability stable
     */
    set qnaRuntimeEndpoint(value: string);
    /**
     * @stability stable
     */
    resetQnaRuntimeEndpoint(): void;
    /**
     * @stability stable
     */
    get qnaRuntimeEndpointInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAccessKey(): string;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): CognitiveAccountIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: CognitiveAccountIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): CognitiveAccountIdentity | undefined;
    private _networkAcls;
    /**
     * @stability stable
     */
    get networkAcls(): CognitiveAccountNetworkAclsOutputReference;
    /**
     * @stability stable
     */
    putNetworkAcls(value: CognitiveAccountNetworkAcls): void;
    /**
     * @stability stable
     */
    resetNetworkAcls(): void;
    /**
     * @stability stable
     */
    get networkAclsInput(): CognitiveAccountNetworkAcls | undefined;
    private _storage?;
    /**
     * @stability stable
     */
    get storage(): CognitiveAccountStorage[];
    /**
     * @stability stable
     */
    set storage(value: CognitiveAccountStorage[]);
    /**
     * @stability stable
     */
    resetStorage(): void;
    /**
     * @stability stable
     */
    get storageInput(): CognitiveAccountStorage[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CognitiveAccountTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CognitiveAccountTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CognitiveAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
