import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CosmosdbGremlinGraphConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#account_name CosmosdbGremlinGraph#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#database_name CosmosdbGremlinGraph#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#default_ttl CosmosdbGremlinGraph#default_ttl}.
     *
     * @stability stable
     */
    readonly defaultTtl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#name CosmosdbGremlinGraph#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#partition_key_path CosmosdbGremlinGraph#partition_key_path}.
     *
     * @stability stable
     */
    readonly partitionKeyPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#partition_key_version CosmosdbGremlinGraph#partition_key_version}.
     *
     * @stability stable
     */
    readonly partitionKeyVersion?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#resource_group_name CosmosdbGremlinGraph#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#throughput CosmosdbGremlinGraph#throughput}.
     *
     * @stability stable
     */
    readonly throughput?: number;
    /**
     * autoscale_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#autoscale_settings CosmosdbGremlinGraph#autoscale_settings}
     *
     * @stability stable
     */
    readonly autoscaleSettings?: CosmosdbGremlinGraphAutoscaleSettings;
    /**
     * conflict_resolution_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#conflict_resolution_policy CosmosdbGremlinGraph#conflict_resolution_policy}
     *
     * @stability stable
     */
    readonly conflictResolutionPolicy?: CosmosdbGremlinGraphConflictResolutionPolicy;
    /**
     * index_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#index_policy CosmosdbGremlinGraph#index_policy}
     *
     * @stability stable
     */
    readonly indexPolicy?: CosmosdbGremlinGraphIndexPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#timeouts CosmosdbGremlinGraph#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CosmosdbGremlinGraphTimeouts;
    /**
     * unique_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#unique_key CosmosdbGremlinGraph#unique_key}
     *
     * @stability stable
     */
    readonly uniqueKey?: CosmosdbGremlinGraphUniqueKey[];
}
/**
 * @stability stable
 */
export interface CosmosdbGremlinGraphAutoscaleSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#max_throughput CosmosdbGremlinGraph#max_throughput}.
     *
     * @stability stable
     */
    readonly maxThroughput?: number;
}
export declare function cosmosdbGremlinGraphAutoscaleSettingsToTerraform(struct?: CosmosdbGremlinGraphAutoscaleSettingsOutputReference | CosmosdbGremlinGraphAutoscaleSettings): any;
/**
 * @stability stable
 */
export declare class CosmosdbGremlinGraphAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbGremlinGraphAutoscaleSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbGremlinGraphAutoscaleSettings | undefined);
    private _maxThroughput?;
    /**
     * @stability stable
     */
    get maxThroughput(): number;
    /**
     * @stability stable
     */
    set maxThroughput(value: number);
    /**
     * @stability stable
     */
    resetMaxThroughput(): void;
    /**
     * @stability stable
     */
    get maxThroughputInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbGremlinGraphConflictResolutionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#conflict_resolution_path CosmosdbGremlinGraph#conflict_resolution_path}.
     *
     * @stability stable
     */
    readonly conflictResolutionPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#conflict_resolution_procedure CosmosdbGremlinGraph#conflict_resolution_procedure}.
     *
     * @stability stable
     */
    readonly conflictResolutionProcedure?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#mode CosmosdbGremlinGraph#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
}
export declare function cosmosdbGremlinGraphConflictResolutionPolicyToTerraform(struct?: CosmosdbGremlinGraphConflictResolutionPolicyOutputReference | CosmosdbGremlinGraphConflictResolutionPolicy): any;
/**
 * @stability stable
 */
export declare class CosmosdbGremlinGraphConflictResolutionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbGremlinGraphConflictResolutionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbGremlinGraphConflictResolutionPolicy | undefined);
    private _conflictResolutionPath?;
    /**
     * @stability stable
     */
    get conflictResolutionPath(): string;
    /**
     * @stability stable
     */
    set conflictResolutionPath(value: string);
    /**
     * @stability stable
     */
    resetConflictResolutionPath(): void;
    /**
     * @stability stable
     */
    get conflictResolutionPathInput(): string | undefined;
    private _conflictResolutionProcedure?;
    /**
     * @stability stable
     */
    get conflictResolutionProcedure(): string;
    /**
     * @stability stable
     */
    set conflictResolutionProcedure(value: string);
    /**
     * @stability stable
     */
    resetConflictResolutionProcedure(): void;
    /**
     * @stability stable
     */
    get conflictResolutionProcedureInput(): string | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbGremlinGraphIndexPolicyCompositeIndexIndex {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#order CosmosdbGremlinGraph#order}.
     *
     * @stability stable
     */
    readonly order: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#path CosmosdbGremlinGraph#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function cosmosdbGremlinGraphIndexPolicyCompositeIndexIndexToTerraform(struct?: CosmosdbGremlinGraphIndexPolicyCompositeIndexIndex): any;
/**
 * @stability stable
 */
export interface CosmosdbGremlinGraphIndexPolicyCompositeIndex {
    /**
     * index block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#index CosmosdbGremlinGraph#index}
     *
     * @stability stable
     */
    readonly index: CosmosdbGremlinGraphIndexPolicyCompositeIndexIndex[];
}
export declare function cosmosdbGremlinGraphIndexPolicyCompositeIndexToTerraform(struct?: CosmosdbGremlinGraphIndexPolicyCompositeIndex): any;
/**
 * @stability stable
 */
export interface CosmosdbGremlinGraphIndexPolicySpatialIndex {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#path CosmosdbGremlinGraph#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function cosmosdbGremlinGraphIndexPolicySpatialIndexToTerraform(struct?: CosmosdbGremlinGraphIndexPolicySpatialIndex): any;
/**
 * @stability stable
 */
export interface CosmosdbGremlinGraphIndexPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#automatic CosmosdbGremlinGraph#automatic}.
     *
     * @stability stable
     */
    readonly automatic?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#excluded_paths CosmosdbGremlinGraph#excluded_paths}.
     *
     * @stability stable
     */
    readonly excludedPaths?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#included_paths CosmosdbGremlinGraph#included_paths}.
     *
     * @stability stable
     */
    readonly includedPaths?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#indexing_mode CosmosdbGremlinGraph#indexing_mode}.
     *
     * @stability stable
     */
    readonly indexingMode: string;
    /**
     * composite_index block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#composite_index CosmosdbGremlinGraph#composite_index}
     *
     * @stability stable
     */
    readonly compositeIndex?: CosmosdbGremlinGraphIndexPolicyCompositeIndex[];
    /**
     * spatial_index block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#spatial_index CosmosdbGremlinGraph#spatial_index}
     *
     * @stability stable
     */
    readonly spatialIndex?: CosmosdbGremlinGraphIndexPolicySpatialIndex[];
}
export declare function cosmosdbGremlinGraphIndexPolicyToTerraform(struct?: CosmosdbGremlinGraphIndexPolicyOutputReference | CosmosdbGremlinGraphIndexPolicy): any;
/**
 * @stability stable
 */
export declare class CosmosdbGremlinGraphIndexPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbGremlinGraphIndexPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbGremlinGraphIndexPolicy | undefined);
    private _automatic?;
    /**
     * @stability stable
     */
    get automatic(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set automatic(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutomatic(): void;
    /**
     * @stability stable
     */
    get automaticInput(): boolean | cdktf.IResolvable | undefined;
    private _excludedPaths?;
    /**
     * @stability stable
     */
    get excludedPaths(): string[];
    /**
     * @stability stable
     */
    set excludedPaths(value: string[]);
    /**
     * @stability stable
     */
    resetExcludedPaths(): void;
    /**
     * @stability stable
     */
    get excludedPathsInput(): string[] | undefined;
    private _includedPaths?;
    /**
     * @stability stable
     */
    get includedPaths(): string[];
    /**
     * @stability stable
     */
    set includedPaths(value: string[]);
    /**
     * @stability stable
     */
    resetIncludedPaths(): void;
    /**
     * @stability stable
     */
    get includedPathsInput(): string[] | undefined;
    private _indexingMode?;
    /**
     * @stability stable
     */
    get indexingMode(): string;
    /**
     * @stability stable
     */
    set indexingMode(value: string);
    /**
     * @stability stable
     */
    get indexingModeInput(): string | undefined;
    private _compositeIndex?;
    /**
     * @stability stable
     */
    get compositeIndex(): CosmosdbGremlinGraphIndexPolicyCompositeIndex[];
    /**
     * @stability stable
     */
    set compositeIndex(value: CosmosdbGremlinGraphIndexPolicyCompositeIndex[]);
    /**
     * @stability stable
     */
    resetCompositeIndex(): void;
    /**
     * @stability stable
     */
    get compositeIndexInput(): CosmosdbGremlinGraphIndexPolicyCompositeIndex[] | undefined;
    private _spatialIndex?;
    /**
     * @stability stable
     */
    get spatialIndex(): CosmosdbGremlinGraphIndexPolicySpatialIndex[];
    /**
     * @stability stable
     */
    set spatialIndex(value: CosmosdbGremlinGraphIndexPolicySpatialIndex[]);
    /**
     * @stability stable
     */
    resetSpatialIndex(): void;
    /**
     * @stability stable
     */
    get spatialIndexInput(): CosmosdbGremlinGraphIndexPolicySpatialIndex[] | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbGremlinGraphTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#create CosmosdbGremlinGraph#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#delete CosmosdbGremlinGraph#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#read CosmosdbGremlinGraph#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#update CosmosdbGremlinGraph#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cosmosdbGremlinGraphTimeoutsToTerraform(struct?: CosmosdbGremlinGraphTimeoutsOutputReference | CosmosdbGremlinGraphTimeouts): any;
/**
 * @stability stable
 */
export declare class CosmosdbGremlinGraphTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbGremlinGraphTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbGremlinGraphTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbGremlinGraphUniqueKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html#paths CosmosdbGremlinGraph#paths}.
     *
     * @stability stable
     */
    readonly paths: string[];
}
export declare function cosmosdbGremlinGraphUniqueKeyToTerraform(struct?: CosmosdbGremlinGraphUniqueKey): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html azurerm_cosmosdb_gremlin_graph}.
 *
 * @stability stable
 */
export declare class CosmosdbGremlinGraph extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_gremlin_graph.html azurerm_cosmosdb_gremlin_graph} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CosmosdbGremlinGraphConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _defaultTtl?;
    /**
     * @stability stable
     */
    get defaultTtl(): number;
    /**
     * @stability stable
     */
    set defaultTtl(value: number);
    /**
     * @stability stable
     */
    resetDefaultTtl(): void;
    /**
     * @stability stable
     */
    get defaultTtlInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _partitionKeyPath?;
    /**
     * @stability stable
     */
    get partitionKeyPath(): string;
    /**
     * @stability stable
     */
    set partitionKeyPath(value: string);
    /**
     * @stability stable
     */
    get partitionKeyPathInput(): string | undefined;
    private _partitionKeyVersion?;
    /**
     * @stability stable
     */
    get partitionKeyVersion(): number;
    /**
     * @stability stable
     */
    set partitionKeyVersion(value: number);
    /**
     * @stability stable
     */
    resetPartitionKeyVersion(): void;
    /**
     * @stability stable
     */
    get partitionKeyVersionInput(): number | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _throughput?;
    /**
     * @stability stable
     */
    get throughput(): number;
    /**
     * @stability stable
     */
    set throughput(value: number);
    /**
     * @stability stable
     */
    resetThroughput(): void;
    /**
     * @stability stable
     */
    get throughputInput(): number | undefined;
    private _autoscaleSettings;
    /**
     * @stability stable
     */
    get autoscaleSettings(): CosmosdbGremlinGraphAutoscaleSettingsOutputReference;
    /**
     * @stability stable
     */
    putAutoscaleSettings(value: CosmosdbGremlinGraphAutoscaleSettings): void;
    /**
     * @stability stable
     */
    resetAutoscaleSettings(): void;
    /**
     * @stability stable
     */
    get autoscaleSettingsInput(): CosmosdbGremlinGraphAutoscaleSettings | undefined;
    private _conflictResolutionPolicy;
    /**
     * @stability stable
     */
    get conflictResolutionPolicy(): CosmosdbGremlinGraphConflictResolutionPolicyOutputReference;
    /**
     * @stability stable
     */
    putConflictResolutionPolicy(value: CosmosdbGremlinGraphConflictResolutionPolicy): void;
    /**
     * @stability stable
     */
    resetConflictResolutionPolicy(): void;
    /**
     * @stability stable
     */
    get conflictResolutionPolicyInput(): CosmosdbGremlinGraphConflictResolutionPolicy | undefined;
    private _indexPolicy;
    /**
     * @stability stable
     */
    get indexPolicy(): CosmosdbGremlinGraphIndexPolicyOutputReference;
    /**
     * @stability stable
     */
    putIndexPolicy(value: CosmosdbGremlinGraphIndexPolicy): void;
    /**
     * @stability stable
     */
    resetIndexPolicy(): void;
    /**
     * @stability stable
     */
    get indexPolicyInput(): CosmosdbGremlinGraphIndexPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CosmosdbGremlinGraphTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CosmosdbGremlinGraphTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CosmosdbGremlinGraphTimeouts | undefined;
    private _uniqueKey?;
    /**
     * @stability stable
     */
    get uniqueKey(): CosmosdbGremlinGraphUniqueKey[];
    /**
     * @stability stable
     */
    set uniqueKey(value: CosmosdbGremlinGraphUniqueKey[]);
    /**
     * @stability stable
     */
    resetUniqueKey(): void;
    /**
     * @stability stable
     */
    get uniqueKeyInput(): CosmosdbGremlinGraphUniqueKey[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
