import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermApplicationSecurityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_security_group.html#name DataAzurermApplicationSecurityGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_security_group.html#resource_group_name DataAzurermApplicationSecurityGroup#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_security_group.html#timeouts DataAzurermApplicationSecurityGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermApplicationSecurityGroupTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermApplicationSecurityGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/application_security_group.html#read DataAzurermApplicationSecurityGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermApplicationSecurityGroupTimeoutsToTerraform(struct?: DataAzurermApplicationSecurityGroupTimeoutsOutputReference | DataAzurermApplicationSecurityGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermApplicationSecurityGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermApplicationSecurityGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermApplicationSecurityGroupTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/application_security_group.html azurerm_application_security_group}.
 *
 * @stability stable
 */
export declare class DataAzurermApplicationSecurityGroup extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/application_security_group.html azurerm_application_security_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermApplicationSecurityGroupConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermApplicationSecurityGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermApplicationSecurityGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermApplicationSecurityGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
