import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermMaintenanceConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maintenance_configuration.html#name DataAzurermMaintenanceConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maintenance_configuration.html#resource_group_name DataAzurermMaintenanceConfiguration#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maintenance_configuration.html#timeouts DataAzurermMaintenanceConfiguration#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermMaintenanceConfigurationTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermMaintenanceConfigurationWindow extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get duration(): string;
    /**
     * @stability stable
     */
    get expirationDateTime(): string;
    /**
     * @stability stable
     */
    get recurEvery(): string;
    /**
     * @stability stable
     */
    get startDateTime(): string;
    /**
     * @stability stable
     */
    get timeZone(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermMaintenanceConfigurationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maintenance_configuration.html#read DataAzurermMaintenanceConfiguration#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermMaintenanceConfigurationTimeoutsToTerraform(struct?: DataAzurermMaintenanceConfigurationTimeoutsOutputReference | DataAzurermMaintenanceConfigurationTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermMaintenanceConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermMaintenanceConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermMaintenanceConfigurationTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/maintenance_configuration.html azurerm_maintenance_configuration}.
 *
 * @stability stable
 */
export declare class DataAzurermMaintenanceConfiguration extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/maintenance_configuration.html azurerm_maintenance_configuration} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermMaintenanceConfigurationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    properties(key: string): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get visibility(): string;
    /**
     * @stability stable
     */
    window(index: string): DataAzurermMaintenanceConfigurationWindow;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermMaintenanceConfigurationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermMaintenanceConfigurationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermMaintenanceConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
