import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermPolicySetDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition.html#display_name DataAzurermPolicySetDefinition#display_name}.
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition.html#management_group_name DataAzurermPolicySetDefinition#management_group_name}.
     *
     * @stability stable
     */
    readonly managementGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition.html#name DataAzurermPolicySetDefinition#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition.html#timeouts DataAzurermPolicySetDefinition#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermPolicySetDefinitionTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermPolicySetDefinitionPolicyDefinitionGroup extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get additionalMetadataResourceId(): string;
    /**
     * @stability stable
     */
    get category(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermPolicySetDefinitionPolicyDefinitionReference extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get parameterValues(): string;
    /**
     * @stability stable
     */
    get parameters(): any;
    /**
     * @stability stable
     */
    get policyDefinitionId(): string;
    /**
     * @stability stable
     */
    get policyGroupNames(): string[];
    /**
     * @stability stable
     */
    get referenceId(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermPolicySetDefinitionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition.html#read DataAzurermPolicySetDefinition#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermPolicySetDefinitionTimeoutsToTerraform(struct?: DataAzurermPolicySetDefinitionTimeoutsOutputReference | DataAzurermPolicySetDefinitionTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermPolicySetDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermPolicySetDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermPolicySetDefinitionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition.html azurerm_policy_set_definition}.
 *
 * @stability stable
 */
export declare class DataAzurermPolicySetDefinition extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition.html azurerm_policy_set_definition} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzurermPolicySetDefinitionConfig);
    /**
     * @stability stable
     */
    get description(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _managementGroupName?;
    /**
     * @stability stable
     */
    get managementGroupName(): string;
    /**
     * @stability stable
     */
    set managementGroupName(value: string);
    /**
     * @stability stable
     */
    resetManagementGroupName(): void;
    /**
     * @stability stable
     */
    get managementGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get metadata(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get parameters(): string;
    /**
     * @stability stable
     */
    policyDefinitionGroup(index: string): DataAzurermPolicySetDefinitionPolicyDefinitionGroup;
    /**
     * @stability stable
     */
    policyDefinitionReference(index: string): DataAzurermPolicySetDefinitionPolicyDefinitionReference;
    /**
     * @stability stable
     */
    get policyDefinitions(): string;
    /**
     * @stability stable
     */
    get policyType(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermPolicySetDefinitionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermPolicySetDefinitionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermPolicySetDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
