import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermPublicIpsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips.html#allocation_type DataAzurermPublicIps#allocation_type}.
     *
     * @stability stable
     */
    readonly allocationType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips.html#attached DataAzurermPublicIps#attached}.
     *
     * @stability stable
     */
    readonly attached?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips.html#attachment_status DataAzurermPublicIps#attachment_status}.
     *
     * @stability stable
     */
    readonly attachmentStatus?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips.html#name_prefix DataAzurermPublicIps#name_prefix}.
     *
     * @stability stable
     */
    readonly namePrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips.html#resource_group_name DataAzurermPublicIps#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips.html#timeouts DataAzurermPublicIps#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermPublicIpsTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermPublicIpsPublicIps extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get domainNameLabel(): string;
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermPublicIpsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips.html#read DataAzurermPublicIps#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermPublicIpsTimeoutsToTerraform(struct?: DataAzurermPublicIpsTimeoutsOutputReference | DataAzurermPublicIpsTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermPublicIpsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermPublicIpsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermPublicIpsTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips.html azurerm_public_ips}.
 *
 * @stability stable
 */
export declare class DataAzurermPublicIps extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/public_ips.html azurerm_public_ips} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermPublicIpsConfig);
    private _allocationType?;
    /**
     * @stability stable
     */
    get allocationType(): string;
    /**
     * @stability stable
     */
    set allocationType(value: string);
    /**
     * @stability stable
     */
    resetAllocationType(): void;
    /**
     * @stability stable
     */
    get allocationTypeInput(): string | undefined;
    private _attached?;
    /**
     * @stability stable
     */
    get attached(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set attached(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAttached(): void;
    /**
     * @stability stable
     */
    get attachedInput(): boolean | cdktf.IResolvable | undefined;
    private _attachmentStatus?;
    /**
     * @stability stable
     */
    get attachmentStatus(): string;
    /**
     * @stability stable
     */
    set attachmentStatus(value: string);
    /**
     * @stability stable
     */
    resetAttachmentStatus(): void;
    /**
     * @stability stable
     */
    get attachmentStatusInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _namePrefix?;
    /**
     * @stability stable
     */
    get namePrefix(): string;
    /**
     * @stability stable
     */
    set namePrefix(value: string);
    /**
     * @stability stable
     */
    resetNamePrefix(): void;
    /**
     * @stability stable
     */
    get namePrefixInput(): string | undefined;
    /**
     * @stability stable
     */
    publicIps(index: string): DataAzurermPublicIpsPublicIps;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermPublicIpsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermPublicIpsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermPublicIpsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
