import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceAzureSearchConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#additional_properties DataFactoryLinkedServiceAzureSearch#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#annotations DataFactoryLinkedServiceAzureSearch#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#data_factory_id DataFactoryLinkedServiceAzureSearch#data_factory_id}.
     *
     * @stability stable
     */
    readonly dataFactoryId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#description DataFactoryLinkedServiceAzureSearch#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#integration_runtime_name DataFactoryLinkedServiceAzureSearch#integration_runtime_name}.
     *
     * @stability stable
     */
    readonly integrationRuntimeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#name DataFactoryLinkedServiceAzureSearch#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#parameters DataFactoryLinkedServiceAzureSearch#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#search_service_key DataFactoryLinkedServiceAzureSearch#search_service_key}.
     *
     * @stability stable
     */
    readonly searchServiceKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#url DataFactoryLinkedServiceAzureSearch#url}.
     *
     * @stability stable
     */
    readonly url: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#timeouts DataFactoryLinkedServiceAzureSearch#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryLinkedServiceAzureSearchTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceAzureSearchTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#create DataFactoryLinkedServiceAzureSearch#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#delete DataFactoryLinkedServiceAzureSearch#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#read DataFactoryLinkedServiceAzureSearch#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html#update DataFactoryLinkedServiceAzureSearch#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryLinkedServiceAzureSearchTimeoutsToTerraform(struct?: DataFactoryLinkedServiceAzureSearchTimeoutsOutputReference | DataFactoryLinkedServiceAzureSearchTimeouts): any;
/**
 * @stability stable
 */
export declare class DataFactoryLinkedServiceAzureSearchTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryLinkedServiceAzureSearchTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryLinkedServiceAzureSearchTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html azurerm_data_factory_linked_service_azure_search}.
 *
 * @stability stable
 */
export declare class DataFactoryLinkedServiceAzureSearch extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_search.html azurerm_data_factory_linked_service_azure_search} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryLinkedServiceAzureSearchConfig);
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    /**
     * @stability stable
     */
    get dataFactoryId(): string;
    /**
     * @stability stable
     */
    set dataFactoryId(value: string);
    /**
     * @stability stable
     */
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get encryptedCredential(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _integrationRuntimeName?;
    /**
     * @stability stable
     */
    get integrationRuntimeName(): string;
    /**
     * @stability stable
     */
    set integrationRuntimeName(value: string);
    /**
     * @stability stable
     */
    resetIntegrationRuntimeName(): void;
    /**
     * @stability stable
     */
    get integrationRuntimeNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _searchServiceKey?;
    /**
     * @stability stable
     */
    get searchServiceKey(): string;
    /**
     * @stability stable
     */
    set searchServiceKey(value: string);
    /**
     * @stability stable
     */
    get searchServiceKeyInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryLinkedServiceAzureSearchTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryLinkedServiceAzureSearchTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryLinkedServiceAzureSearchTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
