import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceCosmosdbConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#account_endpoint DataFactoryLinkedServiceCosmosdb#account_endpoint}.
     *
     * @stability stable
     */
    readonly accountEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#account_key DataFactoryLinkedServiceCosmosdb#account_key}.
     *
     * @stability stable
     */
    readonly accountKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#additional_properties DataFactoryLinkedServiceCosmosdb#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#annotations DataFactoryLinkedServiceCosmosdb#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#connection_string DataFactoryLinkedServiceCosmosdb#connection_string}.
     *
     * @stability stable
     */
    readonly connectionString?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#data_factory_name DataFactoryLinkedServiceCosmosdb#data_factory_name}.
     *
     * @stability stable
     */
    readonly dataFactoryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#database DataFactoryLinkedServiceCosmosdb#database}.
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#description DataFactoryLinkedServiceCosmosdb#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#integration_runtime_name DataFactoryLinkedServiceCosmosdb#integration_runtime_name}.
     *
     * @stability stable
     */
    readonly integrationRuntimeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#name DataFactoryLinkedServiceCosmosdb#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#parameters DataFactoryLinkedServiceCosmosdb#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#resource_group_name DataFactoryLinkedServiceCosmosdb#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#timeouts DataFactoryLinkedServiceCosmosdb#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryLinkedServiceCosmosdbTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceCosmosdbTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#create DataFactoryLinkedServiceCosmosdb#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#delete DataFactoryLinkedServiceCosmosdb#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#read DataFactoryLinkedServiceCosmosdb#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html#update DataFactoryLinkedServiceCosmosdb#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryLinkedServiceCosmosdbTimeoutsToTerraform(struct?: DataFactoryLinkedServiceCosmosdbTimeoutsOutputReference | DataFactoryLinkedServiceCosmosdbTimeouts): any;
/**
 * @stability stable
 */
export declare class DataFactoryLinkedServiceCosmosdbTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryLinkedServiceCosmosdbTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryLinkedServiceCosmosdbTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html azurerm_data_factory_linked_service_cosmosdb}.
 *
 * @stability stable
 */
export declare class DataFactoryLinkedServiceCosmosdb extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_cosmosdb.html azurerm_data_factory_linked_service_cosmosdb} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryLinkedServiceCosmosdbConfig);
    private _accountEndpoint?;
    /**
     * @stability stable
     */
    get accountEndpoint(): string;
    /**
     * @stability stable
     */
    set accountEndpoint(value: string);
    /**
     * @stability stable
     */
    resetAccountEndpoint(): void;
    /**
     * @stability stable
     */
    get accountEndpointInput(): string | undefined;
    private _accountKey?;
    /**
     * @stability stable
     */
    get accountKey(): string;
    /**
     * @stability stable
     */
    set accountKey(value: string);
    /**
     * @stability stable
     */
    resetAccountKey(): void;
    /**
     * @stability stable
     */
    get accountKeyInput(): string | undefined;
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    set connectionString(value: string);
    /**
     * @stability stable
     */
    resetConnectionString(): void;
    /**
     * @stability stable
     */
    get connectionStringInput(): string | undefined;
    private _dataFactoryName?;
    /**
     * @stability stable
     */
    get dataFactoryName(): string;
    /**
     * @stability stable
     */
    set dataFactoryName(value: string);
    /**
     * @stability stable
     */
    get dataFactoryNameInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    resetDatabase(): void;
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _integrationRuntimeName?;
    /**
     * @stability stable
     */
    get integrationRuntimeName(): string;
    /**
     * @stability stable
     */
    set integrationRuntimeName(value: string);
    /**
     * @stability stable
     */
    resetIntegrationRuntimeName(): void;
    /**
     * @stability stable
     */
    get integrationRuntimeNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryLinkedServiceCosmosdbTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryLinkedServiceCosmosdbTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryLinkedServiceCosmosdbTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
