import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HpcCacheBlobTargetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html#access_policy_name HpcCacheBlobTarget#access_policy_name}.
     *
     * @stability stable
     */
    readonly accessPolicyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html#cache_name HpcCacheBlobTarget#cache_name}.
     *
     * @stability stable
     */
    readonly cacheName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html#name HpcCacheBlobTarget#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html#namespace_path HpcCacheBlobTarget#namespace_path}.
     *
     * @stability stable
     */
    readonly namespacePath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html#resource_group_name HpcCacheBlobTarget#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html#storage_container_id HpcCacheBlobTarget#storage_container_id}.
     *
     * @stability stable
     */
    readonly storageContainerId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html#timeouts HpcCacheBlobTarget#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HpcCacheBlobTargetTimeouts;
}
/**
 * @stability stable
 */
export interface HpcCacheBlobTargetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html#create HpcCacheBlobTarget#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html#delete HpcCacheBlobTarget#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html#read HpcCacheBlobTarget#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html#update HpcCacheBlobTarget#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function hpcCacheBlobTargetTimeoutsToTerraform(struct?: HpcCacheBlobTargetTimeoutsOutputReference | HpcCacheBlobTargetTimeouts): any;
/**
 * @stability stable
 */
export declare class HpcCacheBlobTargetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HpcCacheBlobTargetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HpcCacheBlobTargetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html azurerm_hpc_cache_blob_target}.
 *
 * @stability stable
 */
export declare class HpcCacheBlobTarget extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_target.html azurerm_hpc_cache_blob_target} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HpcCacheBlobTargetConfig);
    private _accessPolicyName?;
    /**
     * @stability stable
     */
    get accessPolicyName(): string;
    /**
     * @stability stable
     */
    set accessPolicyName(value: string);
    /**
     * @stability stable
     */
    resetAccessPolicyName(): void;
    /**
     * @stability stable
     */
    get accessPolicyNameInput(): string | undefined;
    private _cacheName?;
    /**
     * @stability stable
     */
    get cacheName(): string;
    /**
     * @stability stable
     */
    set cacheName(value: string);
    /**
     * @stability stable
     */
    get cacheNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespacePath?;
    /**
     * @stability stable
     */
    get namespacePath(): string;
    /**
     * @stability stable
     */
    set namespacePath(value: string);
    /**
     * @stability stable
     */
    get namespacePathInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _storageContainerId?;
    /**
     * @stability stable
     */
    get storageContainerId(): string;
    /**
     * @stability stable
     */
    set storageContainerId(value: string);
    /**
     * @stability stable
     */
    get storageContainerIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HpcCacheBlobTargetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HpcCacheBlobTargetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HpcCacheBlobTargetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
