import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#auto_start NetworkConnectionMonitor#auto_start}.
     *
     * @stability stable
     */
    readonly autoStart?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#interval_in_seconds NetworkConnectionMonitor#interval_in_seconds}.
     *
     * @stability stable
     */
    readonly intervalInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#location NetworkConnectionMonitor#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#name NetworkConnectionMonitor#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#network_watcher_id NetworkConnectionMonitor#network_watcher_id}.
     *
     * @stability stable
     */
    readonly networkWatcherId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#notes NetworkConnectionMonitor#notes}.
     *
     * @stability stable
     */
    readonly notes?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#output_workspace_resource_ids NetworkConnectionMonitor#output_workspace_resource_ids}.
     *
     * @stability stable
     */
    readonly outputWorkspaceResourceIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#tags NetworkConnectionMonitor#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#destination NetworkConnectionMonitor#destination}
     *
     * @stability stable
     */
    readonly destination?: NetworkConnectionMonitorDestination;
    /**
     * endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#endpoint NetworkConnectionMonitor#endpoint}
     *
     * @stability stable
     */
    readonly endpoint: NetworkConnectionMonitorEndpoint[];
    /**
     * source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#source NetworkConnectionMonitor#source}
     *
     * @stability stable
     */
    readonly source?: NetworkConnectionMonitorSource;
    /**
     * test_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#test_configuration NetworkConnectionMonitor#test_configuration}
     *
     * @stability stable
     */
    readonly testConfiguration: NetworkConnectionMonitorTestConfiguration[];
    /**
     * test_group block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#test_group NetworkConnectionMonitor#test_group}
     *
     * @stability stable
     */
    readonly testGroup: NetworkConnectionMonitorTestGroup[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#timeouts NetworkConnectionMonitor#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkConnectionMonitorTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorDestination {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#address NetworkConnectionMonitor#address}.
     *
     * @stability stable
     */
    readonly address?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#port NetworkConnectionMonitor#port}.
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#virtual_machine_id NetworkConnectionMonitor#virtual_machine_id}.
     *
     * @stability stable
     */
    readonly virtualMachineId?: string;
}
export declare function networkConnectionMonitorDestinationToTerraform(struct?: NetworkConnectionMonitorDestinationOutputReference | NetworkConnectionMonitorDestination): any;
/**
 * @stability stable
 */
export declare class NetworkConnectionMonitorDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkConnectionMonitorDestination | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkConnectionMonitorDestination | undefined);
    private _address?;
    /**
     * @stability stable
     */
    get address(): string;
    /**
     * @stability stable
     */
    set address(value: string);
    /**
     * @stability stable
     */
    resetAddress(): void;
    /**
     * @stability stable
     */
    get addressInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _virtualMachineId?;
    /**
     * @stability stable
     */
    get virtualMachineId(): string;
    /**
     * @stability stable
     */
    set virtualMachineId(value: string);
    /**
     * @stability stable
     */
    resetVirtualMachineId(): void;
    /**
     * @stability stable
     */
    get virtualMachineIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorEndpointFilterItem {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#address NetworkConnectionMonitor#address}.
     *
     * @stability stable
     */
    readonly address?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#type NetworkConnectionMonitor#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function networkConnectionMonitorEndpointFilterItemToTerraform(struct?: NetworkConnectionMonitorEndpointFilterItem): any;
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorEndpointFilter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#type NetworkConnectionMonitor#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * item block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#item NetworkConnectionMonitor#item}
     *
     * @stability stable
     */
    readonly item?: NetworkConnectionMonitorEndpointFilterItem[];
}
export declare function networkConnectionMonitorEndpointFilterToTerraform(struct?: NetworkConnectionMonitorEndpointFilterOutputReference | NetworkConnectionMonitorEndpointFilter): any;
/**
 * @stability stable
 */
export declare class NetworkConnectionMonitorEndpointFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkConnectionMonitorEndpointFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkConnectionMonitorEndpointFilter | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _item?;
    /**
     * @stability stable
     */
    get item(): NetworkConnectionMonitorEndpointFilterItem[];
    /**
     * @stability stable
     */
    set item(value: NetworkConnectionMonitorEndpointFilterItem[]);
    /**
     * @stability stable
     */
    resetItem(): void;
    /**
     * @stability stable
     */
    get itemInput(): NetworkConnectionMonitorEndpointFilterItem[] | undefined;
}
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#address NetworkConnectionMonitor#address}.
     *
     * @stability stable
     */
    readonly address?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#coverage_level NetworkConnectionMonitor#coverage_level}.
     *
     * @stability stable
     */
    readonly coverageLevel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#excluded_ip_addresses NetworkConnectionMonitor#excluded_ip_addresses}.
     *
     * @stability stable
     */
    readonly excludedIpAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#included_ip_addresses NetworkConnectionMonitor#included_ip_addresses}.
     *
     * @stability stable
     */
    readonly includedIpAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#name NetworkConnectionMonitor#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#target_resource_id NetworkConnectionMonitor#target_resource_id}.
     *
     * @stability stable
     */
    readonly targetResourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#target_resource_type NetworkConnectionMonitor#target_resource_type}.
     *
     * @stability stable
     */
    readonly targetResourceType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#virtual_machine_id NetworkConnectionMonitor#virtual_machine_id}.
     *
     * @stability stable
     */
    readonly virtualMachineId?: string;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#filter NetworkConnectionMonitor#filter}
     *
     * @stability stable
     */
    readonly filter?: NetworkConnectionMonitorEndpointFilter;
}
export declare function networkConnectionMonitorEndpointToTerraform(struct?: NetworkConnectionMonitorEndpoint): any;
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorSource {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#port NetworkConnectionMonitor#port}.
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#virtual_machine_id NetworkConnectionMonitor#virtual_machine_id}.
     *
     * @stability stable
     */
    readonly virtualMachineId?: string;
}
export declare function networkConnectionMonitorSourceToTerraform(struct?: NetworkConnectionMonitorSourceOutputReference | NetworkConnectionMonitorSource): any;
/**
 * @stability stable
 */
export declare class NetworkConnectionMonitorSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkConnectionMonitorSource | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkConnectionMonitorSource | undefined);
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _virtualMachineId?;
    /**
     * @stability stable
     */
    get virtualMachineId(): string;
    /**
     * @stability stable
     */
    set virtualMachineId(value: string);
    /**
     * @stability stable
     */
    resetVirtualMachineId(): void;
    /**
     * @stability stable
     */
    get virtualMachineIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorTestConfigurationHttpConfigurationRequestHeader {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#name NetworkConnectionMonitor#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#value NetworkConnectionMonitor#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function networkConnectionMonitorTestConfigurationHttpConfigurationRequestHeaderToTerraform(struct?: NetworkConnectionMonitorTestConfigurationHttpConfigurationRequestHeader): any;
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorTestConfigurationHttpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#method NetworkConnectionMonitor#method}.
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#path NetworkConnectionMonitor#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#port NetworkConnectionMonitor#port}.
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#prefer_https NetworkConnectionMonitor#prefer_https}.
     *
     * @stability stable
     */
    readonly preferHttps?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#valid_status_code_ranges NetworkConnectionMonitor#valid_status_code_ranges}.
     *
     * @stability stable
     */
    readonly validStatusCodeRanges?: string[];
    /**
     * request_header block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#request_header NetworkConnectionMonitor#request_header}
     *
     * @stability stable
     */
    readonly requestHeader?: NetworkConnectionMonitorTestConfigurationHttpConfigurationRequestHeader[];
}
export declare function networkConnectionMonitorTestConfigurationHttpConfigurationToTerraform(struct?: NetworkConnectionMonitorTestConfigurationHttpConfigurationOutputReference | NetworkConnectionMonitorTestConfigurationHttpConfiguration): any;
/**
 * @stability stable
 */
export declare class NetworkConnectionMonitorTestConfigurationHttpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkConnectionMonitorTestConfigurationHttpConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkConnectionMonitorTestConfigurationHttpConfiguration | undefined);
    private _method?;
    /**
     * @stability stable
     */
    get method(): string;
    /**
     * @stability stable
     */
    set method(value: string);
    /**
     * @stability stable
     */
    resetMethod(): void;
    /**
     * @stability stable
     */
    get methodInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _preferHttps?;
    /**
     * @stability stable
     */
    get preferHttps(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preferHttps(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreferHttps(): void;
    /**
     * @stability stable
     */
    get preferHttpsInput(): boolean | cdktf.IResolvable | undefined;
    private _validStatusCodeRanges?;
    /**
     * @stability stable
     */
    get validStatusCodeRanges(): string[];
    /**
     * @stability stable
     */
    set validStatusCodeRanges(value: string[]);
    /**
     * @stability stable
     */
    resetValidStatusCodeRanges(): void;
    /**
     * @stability stable
     */
    get validStatusCodeRangesInput(): string[] | undefined;
    private _requestHeader?;
    /**
     * @stability stable
     */
    get requestHeader(): NetworkConnectionMonitorTestConfigurationHttpConfigurationRequestHeader[];
    /**
     * @stability stable
     */
    set requestHeader(value: NetworkConnectionMonitorTestConfigurationHttpConfigurationRequestHeader[]);
    /**
     * @stability stable
     */
    resetRequestHeader(): void;
    /**
     * @stability stable
     */
    get requestHeaderInput(): NetworkConnectionMonitorTestConfigurationHttpConfigurationRequestHeader[] | undefined;
}
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorTestConfigurationIcmpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#trace_route_enabled NetworkConnectionMonitor#trace_route_enabled}.
     *
     * @stability stable
     */
    readonly traceRouteEnabled?: boolean | cdktf.IResolvable;
}
export declare function networkConnectionMonitorTestConfigurationIcmpConfigurationToTerraform(struct?: NetworkConnectionMonitorTestConfigurationIcmpConfigurationOutputReference | NetworkConnectionMonitorTestConfigurationIcmpConfiguration): any;
/**
 * @stability stable
 */
export declare class NetworkConnectionMonitorTestConfigurationIcmpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkConnectionMonitorTestConfigurationIcmpConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkConnectionMonitorTestConfigurationIcmpConfiguration | undefined);
    private _traceRouteEnabled?;
    /**
     * @stability stable
     */
    get traceRouteEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set traceRouteEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTraceRouteEnabled(): void;
    /**
     * @stability stable
     */
    get traceRouteEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorTestConfigurationSuccessThreshold {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#checks_failed_percent NetworkConnectionMonitor#checks_failed_percent}.
     *
     * @stability stable
     */
    readonly checksFailedPercent?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#round_trip_time_ms NetworkConnectionMonitor#round_trip_time_ms}.
     *
     * @stability stable
     */
    readonly roundTripTimeMs?: number;
}
export declare function networkConnectionMonitorTestConfigurationSuccessThresholdToTerraform(struct?: NetworkConnectionMonitorTestConfigurationSuccessThresholdOutputReference | NetworkConnectionMonitorTestConfigurationSuccessThreshold): any;
/**
 * @stability stable
 */
export declare class NetworkConnectionMonitorTestConfigurationSuccessThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkConnectionMonitorTestConfigurationSuccessThreshold | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkConnectionMonitorTestConfigurationSuccessThreshold | undefined);
    private _checksFailedPercent?;
    /**
     * @stability stable
     */
    get checksFailedPercent(): number;
    /**
     * @stability stable
     */
    set checksFailedPercent(value: number);
    /**
     * @stability stable
     */
    resetChecksFailedPercent(): void;
    /**
     * @stability stable
     */
    get checksFailedPercentInput(): number | undefined;
    private _roundTripTimeMs?;
    /**
     * @stability stable
     */
    get roundTripTimeMs(): number;
    /**
     * @stability stable
     */
    set roundTripTimeMs(value: number);
    /**
     * @stability stable
     */
    resetRoundTripTimeMs(): void;
    /**
     * @stability stable
     */
    get roundTripTimeMsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorTestConfigurationTcpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#destination_port_behavior NetworkConnectionMonitor#destination_port_behavior}.
     *
     * @stability stable
     */
    readonly destinationPortBehavior?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#port NetworkConnectionMonitor#port}.
     *
     * @stability stable
     */
    readonly port: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#trace_route_enabled NetworkConnectionMonitor#trace_route_enabled}.
     *
     * @stability stable
     */
    readonly traceRouteEnabled?: boolean | cdktf.IResolvable;
}
export declare function networkConnectionMonitorTestConfigurationTcpConfigurationToTerraform(struct?: NetworkConnectionMonitorTestConfigurationTcpConfigurationOutputReference | NetworkConnectionMonitorTestConfigurationTcpConfiguration): any;
/**
 * @stability stable
 */
export declare class NetworkConnectionMonitorTestConfigurationTcpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkConnectionMonitorTestConfigurationTcpConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkConnectionMonitorTestConfigurationTcpConfiguration | undefined);
    private _destinationPortBehavior?;
    /**
     * @stability stable
     */
    get destinationPortBehavior(): string;
    /**
     * @stability stable
     */
    set destinationPortBehavior(value: string);
    /**
     * @stability stable
     */
    resetDestinationPortBehavior(): void;
    /**
     * @stability stable
     */
    get destinationPortBehaviorInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _traceRouteEnabled?;
    /**
     * @stability stable
     */
    get traceRouteEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set traceRouteEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTraceRouteEnabled(): void;
    /**
     * @stability stable
     */
    get traceRouteEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorTestConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#name NetworkConnectionMonitor#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#preferred_ip_version NetworkConnectionMonitor#preferred_ip_version}.
     *
     * @stability stable
     */
    readonly preferredIpVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#protocol NetworkConnectionMonitor#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#test_frequency_in_seconds NetworkConnectionMonitor#test_frequency_in_seconds}.
     *
     * @stability stable
     */
    readonly testFrequencyInSeconds?: number;
    /**
     * http_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#http_configuration NetworkConnectionMonitor#http_configuration}
     *
     * @stability stable
     */
    readonly httpConfiguration?: NetworkConnectionMonitorTestConfigurationHttpConfiguration;
    /**
     * icmp_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#icmp_configuration NetworkConnectionMonitor#icmp_configuration}
     *
     * @stability stable
     */
    readonly icmpConfiguration?: NetworkConnectionMonitorTestConfigurationIcmpConfiguration;
    /**
     * success_threshold block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#success_threshold NetworkConnectionMonitor#success_threshold}
     *
     * @stability stable
     */
    readonly successThreshold?: NetworkConnectionMonitorTestConfigurationSuccessThreshold;
    /**
     * tcp_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#tcp_configuration NetworkConnectionMonitor#tcp_configuration}
     *
     * @stability stable
     */
    readonly tcpConfiguration?: NetworkConnectionMonitorTestConfigurationTcpConfiguration;
}
export declare function networkConnectionMonitorTestConfigurationToTerraform(struct?: NetworkConnectionMonitorTestConfiguration): any;
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorTestGroup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#destination_endpoints NetworkConnectionMonitor#destination_endpoints}.
     *
     * @stability stable
     */
    readonly destinationEndpoints: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#enabled NetworkConnectionMonitor#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#name NetworkConnectionMonitor#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#source_endpoints NetworkConnectionMonitor#source_endpoints}.
     *
     * @stability stable
     */
    readonly sourceEndpoints: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#test_configuration_names NetworkConnectionMonitor#test_configuration_names}.
     *
     * @stability stable
     */
    readonly testConfigurationNames: string[];
}
export declare function networkConnectionMonitorTestGroupToTerraform(struct?: NetworkConnectionMonitorTestGroup): any;
/**
 * @stability stable
 */
export interface NetworkConnectionMonitorTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#create NetworkConnectionMonitor#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#delete NetworkConnectionMonitor#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#read NetworkConnectionMonitor#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html#update NetworkConnectionMonitor#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function networkConnectionMonitorTimeoutsToTerraform(struct?: NetworkConnectionMonitorTimeoutsOutputReference | NetworkConnectionMonitorTimeouts): any;
/**
 * @stability stable
 */
export declare class NetworkConnectionMonitorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkConnectionMonitorTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkConnectionMonitorTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html azurerm_network_connection_monitor}.
 *
 * @stability stable
 */
export declare class NetworkConnectionMonitor extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor.html azurerm_network_connection_monitor} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkConnectionMonitorConfig);
    private _autoStart?;
    /**
     * @stability stable
     */
    get autoStart(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoStart(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoStart(): void;
    /**
     * @stability stable
     */
    get autoStartInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _intervalInSeconds?;
    /**
     * @stability stable
     */
    get intervalInSeconds(): number;
    /**
     * @stability stable
     */
    set intervalInSeconds(value: number);
    /**
     * @stability stable
     */
    resetIntervalInSeconds(): void;
    /**
     * @stability stable
     */
    get intervalInSecondsInput(): number | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkWatcherId?;
    /**
     * @stability stable
     */
    get networkWatcherId(): string;
    /**
     * @stability stable
     */
    set networkWatcherId(value: string);
    /**
     * @stability stable
     */
    get networkWatcherIdInput(): string | undefined;
    private _notes?;
    /**
     * @stability stable
     */
    get notes(): string;
    /**
     * @stability stable
     */
    set notes(value: string);
    /**
     * @stability stable
     */
    resetNotes(): void;
    /**
     * @stability stable
     */
    get notesInput(): string | undefined;
    private _outputWorkspaceResourceIds?;
    /**
     * @stability stable
     */
    get outputWorkspaceResourceIds(): string[];
    /**
     * @stability stable
     */
    set outputWorkspaceResourceIds(value: string[]);
    /**
     * @stability stable
     */
    resetOutputWorkspaceResourceIds(): void;
    /**
     * @stability stable
     */
    get outputWorkspaceResourceIdsInput(): string[] | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _destination;
    /**
     * @stability stable
     */
    get destination(): NetworkConnectionMonitorDestinationOutputReference;
    /**
     * @stability stable
     */
    putDestination(value: NetworkConnectionMonitorDestination): void;
    /**
     * @stability stable
     */
    resetDestination(): void;
    /**
     * @stability stable
     */
    get destinationInput(): NetworkConnectionMonitorDestination | undefined;
    private _endpoint?;
    /**
     * @stability stable
     */
    get endpoint(): NetworkConnectionMonitorEndpoint[];
    /**
     * @stability stable
     */
    set endpoint(value: NetworkConnectionMonitorEndpoint[]);
    /**
     * @stability stable
     */
    get endpointInput(): NetworkConnectionMonitorEndpoint[] | undefined;
    private _source;
    /**
     * @stability stable
     */
    get source(): NetworkConnectionMonitorSourceOutputReference;
    /**
     * @stability stable
     */
    putSource(value: NetworkConnectionMonitorSource): void;
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): NetworkConnectionMonitorSource | undefined;
    private _testConfiguration?;
    /**
     * @stability stable
     */
    get testConfiguration(): NetworkConnectionMonitorTestConfiguration[];
    /**
     * @stability stable
     */
    set testConfiguration(value: NetworkConnectionMonitorTestConfiguration[]);
    /**
     * @stability stable
     */
    get testConfigurationInput(): NetworkConnectionMonitorTestConfiguration[] | undefined;
    private _testGroup?;
    /**
     * @stability stable
     */
    get testGroup(): NetworkConnectionMonitorTestGroup[];
    /**
     * @stability stable
     */
    set testGroup(value: NetworkConnectionMonitorTestGroup[]);
    /**
     * @stability stable
     */
    get testGroupInput(): NetworkConnectionMonitorTestGroup[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetworkConnectionMonitorTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkConnectionMonitorTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkConnectionMonitorTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
