import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServicebusNamespaceDisasterRecoveryConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_disaster_recovery_config.html#name ServicebusNamespaceDisasterRecoveryConfig#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_disaster_recovery_config.html#partner_namespace_id ServicebusNamespaceDisasterRecoveryConfig#partner_namespace_id}.
     *
     * @stability stable
     */
    readonly partnerNamespaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_disaster_recovery_config.html#primary_namespace_id ServicebusNamespaceDisasterRecoveryConfig#primary_namespace_id}.
     *
     * @stability stable
     */
    readonly primaryNamespaceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_disaster_recovery_config.html#timeouts ServicebusNamespaceDisasterRecoveryConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServicebusNamespaceDisasterRecoveryConfigTimeouts;
}
/**
 * @stability stable
 */
export interface ServicebusNamespaceDisasterRecoveryConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_disaster_recovery_config.html#create ServicebusNamespaceDisasterRecoveryConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_disaster_recovery_config.html#delete ServicebusNamespaceDisasterRecoveryConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_disaster_recovery_config.html#read ServicebusNamespaceDisasterRecoveryConfig#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_disaster_recovery_config.html#update ServicebusNamespaceDisasterRecoveryConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function servicebusNamespaceDisasterRecoveryConfigTimeoutsToTerraform(struct?: ServicebusNamespaceDisasterRecoveryConfigTimeoutsOutputReference | ServicebusNamespaceDisasterRecoveryConfigTimeouts): any;
/**
 * @stability stable
 */
export declare class ServicebusNamespaceDisasterRecoveryConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServicebusNamespaceDisasterRecoveryConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServicebusNamespaceDisasterRecoveryConfigTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_disaster_recovery_config.html azurerm_servicebus_namespace_disaster_recovery_config}.
 *
 * @stability stable
 */
export declare class ServicebusNamespaceDisasterRecoveryConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_namespace_disaster_recovery_config.html azurerm_servicebus_namespace_disaster_recovery_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServicebusNamespaceDisasterRecoveryConfigConfig);
    /**
     * @stability stable
     */
    get defaultPrimaryKey(): string;
    /**
     * @stability stable
     */
    get defaultSecondaryKey(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _partnerNamespaceId?;
    /**
     * @stability stable
     */
    get partnerNamespaceId(): string;
    /**
     * @stability stable
     */
    set partnerNamespaceId(value: string);
    /**
     * @stability stable
     */
    get partnerNamespaceIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryConnectionStringAlias(): string;
    private _primaryNamespaceId?;
    /**
     * @stability stable
     */
    get primaryNamespaceId(): string;
    /**
     * @stability stable
     */
    set primaryNamespaceId(value: string);
    /**
     * @stability stable
     */
    get primaryNamespaceIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryConnectionStringAlias(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServicebusNamespaceDisasterRecoveryConfigTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServicebusNamespaceDisasterRecoveryConfigTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServicebusNamespaceDisasterRecoveryConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
