import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServicebusQueueAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html#listen ServicebusQueueAuthorizationRule#listen}.
     *
     * @stability stable
     */
    readonly listen?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html#manage ServicebusQueueAuthorizationRule#manage}.
     *
     * @stability stable
     */
    readonly manage?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html#name ServicebusQueueAuthorizationRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html#namespace_name ServicebusQueueAuthorizationRule#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html#queue_name ServicebusQueueAuthorizationRule#queue_name}.
     *
     * @stability stable
     */
    readonly queueName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html#resource_group_name ServicebusQueueAuthorizationRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html#send ServicebusQueueAuthorizationRule#send}.
     *
     * @stability stable
     */
    readonly send?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html#timeouts ServicebusQueueAuthorizationRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServicebusQueueAuthorizationRuleTimeouts;
}
/**
 * @stability stable
 */
export interface ServicebusQueueAuthorizationRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html#create ServicebusQueueAuthorizationRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html#delete ServicebusQueueAuthorizationRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html#read ServicebusQueueAuthorizationRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html#update ServicebusQueueAuthorizationRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function servicebusQueueAuthorizationRuleTimeoutsToTerraform(struct?: ServicebusQueueAuthorizationRuleTimeoutsOutputReference | ServicebusQueueAuthorizationRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class ServicebusQueueAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServicebusQueueAuthorizationRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServicebusQueueAuthorizationRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html azurerm_servicebus_queue_authorization_rule}.
 *
 * @stability stable
 */
export declare class ServicebusQueueAuthorizationRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue_authorization_rule.html azurerm_servicebus_queue_authorization_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServicebusQueueAuthorizationRuleConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _listen?;
    /**
     * @stability stable
     */
    get listen(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set listen(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetListen(): void;
    /**
     * @stability stable
     */
    get listenInput(): boolean | cdktf.IResolvable | undefined;
    private _manage?;
    /**
     * @stability stable
     */
    get manage(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set manage(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetManage(): void;
    /**
     * @stability stable
     */
    get manageInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    /**
     * @stability stable
     */
    get primaryConnectionStringAlias(): string;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    private _queueName?;
    /**
     * @stability stable
     */
    get queueName(): string;
    /**
     * @stability stable
     */
    set queueName(value: string);
    /**
     * @stability stable
     */
    get queueNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get secondaryConnectionStringAlias(): string;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
    private _send?;
    /**
     * @stability stable
     */
    get send(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set send(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSend(): void;
    /**
     * @stability stable
     */
    get sendInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServicebusQueueAuthorizationRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServicebusQueueAuthorizationRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServicebusQueueAuthorizationRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
