import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SpringCloudJavaDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#cpu SpringCloudJavaDeployment#cpu}.
     *
     * @stability stable
     */
    readonly cpu?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#environment_variables SpringCloudJavaDeployment#environment_variables}.
     *
     * @stability stable
     */
    readonly environmentVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#instance_count SpringCloudJavaDeployment#instance_count}.
     *
     * @stability stable
     */
    readonly instanceCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#jvm_options SpringCloudJavaDeployment#jvm_options}.
     *
     * @stability stable
     */
    readonly jvmOptions?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#memory_in_gb SpringCloudJavaDeployment#memory_in_gb}.
     *
     * @stability stable
     */
    readonly memoryInGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#name SpringCloudJavaDeployment#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#runtime_version SpringCloudJavaDeployment#runtime_version}.
     *
     * @stability stable
     */
    readonly runtimeVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#spring_cloud_app_id SpringCloudJavaDeployment#spring_cloud_app_id}.
     *
     * @stability stable
     */
    readonly springCloudAppId: string;
    /**
     * quota block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#quota SpringCloudJavaDeployment#quota}
     *
     * @stability stable
     */
    readonly quota?: SpringCloudJavaDeploymentQuota;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#timeouts SpringCloudJavaDeployment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SpringCloudJavaDeploymentTimeouts;
}
/**
 * @stability stable
 */
export interface SpringCloudJavaDeploymentQuota {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#cpu SpringCloudJavaDeployment#cpu}.
     *
     * @stability stable
     */
    readonly cpu?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#memory SpringCloudJavaDeployment#memory}.
     *
     * @stability stable
     */
    readonly memory?: string;
}
export declare function springCloudJavaDeploymentQuotaToTerraform(struct?: SpringCloudJavaDeploymentQuotaOutputReference | SpringCloudJavaDeploymentQuota): any;
/**
 * @stability stable
 */
export declare class SpringCloudJavaDeploymentQuotaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudJavaDeploymentQuota | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudJavaDeploymentQuota | undefined);
    private _cpu?;
    /**
     * @stability stable
     */
    get cpu(): string;
    /**
     * @stability stable
     */
    set cpu(value: string);
    /**
     * @stability stable
     */
    resetCpu(): void;
    /**
     * @stability stable
     */
    get cpuInput(): string | undefined;
    private _memory?;
    /**
     * @stability stable
     */
    get memory(): string;
    /**
     * @stability stable
     */
    set memory(value: string);
    /**
     * @stability stable
     */
    resetMemory(): void;
    /**
     * @stability stable
     */
    get memoryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SpringCloudJavaDeploymentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#create SpringCloudJavaDeployment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#delete SpringCloudJavaDeployment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#read SpringCloudJavaDeployment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html#update SpringCloudJavaDeployment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function springCloudJavaDeploymentTimeoutsToTerraform(struct?: SpringCloudJavaDeploymentTimeoutsOutputReference | SpringCloudJavaDeploymentTimeouts): any;
/**
 * @stability stable
 */
export declare class SpringCloudJavaDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SpringCloudJavaDeploymentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SpringCloudJavaDeploymentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html azurerm_spring_cloud_java_deployment}.
 *
 * @stability stable
 */
export declare class SpringCloudJavaDeployment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment.html azurerm_spring_cloud_java_deployment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SpringCloudJavaDeploymentConfig);
    private _cpu?;
    /**
     * @stability stable
     */
    get cpu(): number;
    /**
     * @stability stable
     */
    set cpu(value: number);
    /**
     * @stability stable
     */
    resetCpu(): void;
    /**
     * @stability stable
     */
    get cpuInput(): number | undefined;
    private _environmentVariables?;
    /**
     * @stability stable
     */
    get environmentVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set environmentVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnvironmentVariables(): void;
    /**
     * @stability stable
     */
    get environmentVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceCount?;
    /**
     * @stability stable
     */
    get instanceCount(): number;
    /**
     * @stability stable
     */
    set instanceCount(value: number);
    /**
     * @stability stable
     */
    resetInstanceCount(): void;
    /**
     * @stability stable
     */
    get instanceCountInput(): number | undefined;
    private _jvmOptions?;
    /**
     * @stability stable
     */
    get jvmOptions(): string;
    /**
     * @stability stable
     */
    set jvmOptions(value: string);
    /**
     * @stability stable
     */
    resetJvmOptions(): void;
    /**
     * @stability stable
     */
    get jvmOptionsInput(): string | undefined;
    private _memoryInGb?;
    /**
     * @stability stable
     */
    get memoryInGb(): number;
    /**
     * @stability stable
     */
    set memoryInGb(value: number);
    /**
     * @stability stable
     */
    resetMemoryInGb(): void;
    /**
     * @stability stable
     */
    get memoryInGbInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _runtimeVersion?;
    /**
     * @stability stable
     */
    get runtimeVersion(): string;
    /**
     * @stability stable
     */
    set runtimeVersion(value: string);
    /**
     * @stability stable
     */
    resetRuntimeVersion(): void;
    /**
     * @stability stable
     */
    get runtimeVersionInput(): string | undefined;
    private _springCloudAppId?;
    /**
     * @stability stable
     */
    get springCloudAppId(): string;
    /**
     * @stability stable
     */
    set springCloudAppId(value: string);
    /**
     * @stability stable
     */
    get springCloudAppIdInput(): string | undefined;
    private _quota;
    /**
     * @stability stable
     */
    get quota(): SpringCloudJavaDeploymentQuotaOutputReference;
    /**
     * @stability stable
     */
    putQuota(value: SpringCloudJavaDeploymentQuota): void;
    /**
     * @stability stable
     */
    resetQuota(): void;
    /**
     * @stability stable
     */
    get quotaInput(): SpringCloudJavaDeploymentQuota | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SpringCloudJavaDeploymentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SpringCloudJavaDeploymentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SpringCloudJavaDeploymentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
