import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#collation SqlDatabase#collation}.
     *
     * @stability stable
     */
    readonly collation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#create_mode SqlDatabase#create_mode}.
     *
     * @stability stable
     */
    readonly createMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#edition SqlDatabase#edition}.
     *
     * @stability stable
     */
    readonly edition?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#elastic_pool_name SqlDatabase#elastic_pool_name}.
     *
     * @stability stable
     */
    readonly elasticPoolName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#extended_auditing_policy SqlDatabase#extended_auditing_policy}.
     *
     * @stability stable
     */
    readonly extendedAuditingPolicy?: SqlDatabaseExtendedAuditingPolicy[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#location SqlDatabase#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#max_size_bytes SqlDatabase#max_size_bytes}.
     *
     * @stability stable
     */
    readonly maxSizeBytes?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#max_size_gb SqlDatabase#max_size_gb}.
     *
     * @stability stable
     */
    readonly maxSizeGb?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#name SqlDatabase#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#read_scale SqlDatabase#read_scale}.
     *
     * @stability stable
     */
    readonly readScale?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#requested_service_objective_id SqlDatabase#requested_service_objective_id}.
     *
     * @stability stable
     */
    readonly requestedServiceObjectiveId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#requested_service_objective_name SqlDatabase#requested_service_objective_name}.
     *
     * @stability stable
     */
    readonly requestedServiceObjectiveName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#resource_group_name SqlDatabase#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#restore_point_in_time SqlDatabase#restore_point_in_time}.
     *
     * @stability stable
     */
    readonly restorePointInTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#server_name SqlDatabase#server_name}.
     *
     * @stability stable
     */
    readonly serverName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#source_database_deletion_date SqlDatabase#source_database_deletion_date}.
     *
     * @stability stable
     */
    readonly sourceDatabaseDeletionDate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#source_database_id SqlDatabase#source_database_id}.
     *
     * @stability stable
     */
    readonly sourceDatabaseId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#tags SqlDatabase#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#zone_redundant SqlDatabase#zone_redundant}.
     *
     * @stability stable
     */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
    /**
     * import block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#import SqlDatabase#import}
     *
     * @stability stable
     */
    readonly import?: SqlDatabaseImport;
    /**
     * threat_detection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#threat_detection_policy SqlDatabase#threat_detection_policy}
     *
     * @stability stable
     */
    readonly threatDetectionPolicy?: SqlDatabaseThreatDetectionPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#timeouts SqlDatabase#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SqlDatabaseTimeouts;
}
/**
 * @stability stable
 */
export interface SqlDatabaseExtendedAuditingPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#log_monitoring_enabled SqlDatabase#log_monitoring_enabled}.
     *
     * @stability stable
     */
    readonly logMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#retention_in_days SqlDatabase#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#storage_account_access_key SqlDatabase#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#storage_account_access_key_is_secondary SqlDatabase#storage_account_access_key_is_secondary}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKeyIsSecondary?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#storage_endpoint SqlDatabase#storage_endpoint}.
     *
     * @stability stable
     */
    readonly storageEndpoint?: string;
}
export declare function sqlDatabaseExtendedAuditingPolicyToTerraform(struct?: SqlDatabaseExtendedAuditingPolicy): any;
/**
 * @stability stable
 */
export interface SqlDatabaseImport {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#administrator_login SqlDatabase#administrator_login}.
     *
     * @stability stable
     */
    readonly administratorLogin: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#administrator_login_password SqlDatabase#administrator_login_password}.
     *
     * @stability stable
     */
    readonly administratorLoginPassword: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#authentication_type SqlDatabase#authentication_type}.
     *
     * @stability stable
     */
    readonly authenticationType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#operation_mode SqlDatabase#operation_mode}.
     *
     * @stability stable
     */
    readonly operationMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#storage_key SqlDatabase#storage_key}.
     *
     * @stability stable
     */
    readonly storageKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#storage_key_type SqlDatabase#storage_key_type}.
     *
     * @stability stable
     */
    readonly storageKeyType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#storage_uri SqlDatabase#storage_uri}.
     *
     * @stability stable
     */
    readonly storageUri: string;
}
export declare function sqlDatabaseImportToTerraform(struct?: SqlDatabaseImportOutputReference | SqlDatabaseImport): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseImportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseImport | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseImport | undefined);
    private _administratorLogin?;
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    set administratorLogin(value: string);
    /**
     * @stability stable
     */
    get administratorLoginInput(): string | undefined;
    private _administratorLoginPassword?;
    /**
     * @stability stable
     */
    get administratorLoginPassword(): string;
    /**
     * @stability stable
     */
    set administratorLoginPassword(value: string);
    /**
     * @stability stable
     */
    get administratorLoginPasswordInput(): string | undefined;
    private _authenticationType?;
    /**
     * @stability stable
     */
    get authenticationType(): string;
    /**
     * @stability stable
     */
    set authenticationType(value: string);
    /**
     * @stability stable
     */
    get authenticationTypeInput(): string | undefined;
    private _operationMode?;
    /**
     * @stability stable
     */
    get operationMode(): string;
    /**
     * @stability stable
     */
    set operationMode(value: string);
    /**
     * @stability stable
     */
    resetOperationMode(): void;
    /**
     * @stability stable
     */
    get operationModeInput(): string | undefined;
    private _storageKey?;
    /**
     * @stability stable
     */
    get storageKey(): string;
    /**
     * @stability stable
     */
    set storageKey(value: string);
    /**
     * @stability stable
     */
    get storageKeyInput(): string | undefined;
    private _storageKeyType?;
    /**
     * @stability stable
     */
    get storageKeyType(): string;
    /**
     * @stability stable
     */
    set storageKeyType(value: string);
    /**
     * @stability stable
     */
    get storageKeyTypeInput(): string | undefined;
    private _storageUri?;
    /**
     * @stability stable
     */
    get storageUri(): string;
    /**
     * @stability stable
     */
    set storageUri(value: string);
    /**
     * @stability stable
     */
    get storageUriInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseThreatDetectionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#disabled_alerts SqlDatabase#disabled_alerts}.
     *
     * @stability stable
     */
    readonly disabledAlerts?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#email_account_admins SqlDatabase#email_account_admins}.
     *
     * @stability stable
     */
    readonly emailAccountAdmins?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#email_addresses SqlDatabase#email_addresses}.
     *
     * @stability stable
     */
    readonly emailAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#retention_days SqlDatabase#retention_days}.
     *
     * @stability stable
     */
    readonly retentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#state SqlDatabase#state}.
     *
     * @stability stable
     */
    readonly state?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#storage_account_access_key SqlDatabase#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#storage_endpoint SqlDatabase#storage_endpoint}.
     *
     * @stability stable
     */
    readonly storageEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#use_server_default SqlDatabase#use_server_default}.
     *
     * @stability stable
     */
    readonly useServerDefault?: string;
}
export declare function sqlDatabaseThreatDetectionPolicyToTerraform(struct?: SqlDatabaseThreatDetectionPolicyOutputReference | SqlDatabaseThreatDetectionPolicy): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseThreatDetectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseThreatDetectionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseThreatDetectionPolicy | undefined);
    private _disabledAlerts?;
    /**
     * @stability stable
     */
    get disabledAlerts(): string[];
    /**
     * @stability stable
     */
    set disabledAlerts(value: string[]);
    /**
     * @stability stable
     */
    resetDisabledAlerts(): void;
    /**
     * @stability stable
     */
    get disabledAlertsInput(): string[] | undefined;
    private _emailAccountAdmins?;
    /**
     * @stability stable
     */
    get emailAccountAdmins(): string;
    /**
     * @stability stable
     */
    set emailAccountAdmins(value: string);
    /**
     * @stability stable
     */
    resetEmailAccountAdmins(): void;
    /**
     * @stability stable
     */
    get emailAccountAdminsInput(): string | undefined;
    private _emailAddresses?;
    /**
     * @stability stable
     */
    get emailAddresses(): string[];
    /**
     * @stability stable
     */
    set emailAddresses(value: string[]);
    /**
     * @stability stable
     */
    resetEmailAddresses(): void;
    /**
     * @stability stable
     */
    get emailAddressesInput(): string[] | undefined;
    private _retentionDays?;
    /**
     * @stability stable
     */
    get retentionDays(): number;
    /**
     * @stability stable
     */
    set retentionDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionDays(): void;
    /**
     * @stability stable
     */
    get retentionDaysInput(): number | undefined;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    set state(value: string);
    /**
     * @stability stable
     */
    resetState(): void;
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountAccessKey(): void;
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageEndpoint?;
    /**
     * @stability stable
     */
    get storageEndpoint(): string;
    /**
     * @stability stable
     */
    set storageEndpoint(value: string);
    /**
     * @stability stable
     */
    resetStorageEndpoint(): void;
    /**
     * @stability stable
     */
    get storageEndpointInput(): string | undefined;
    private _useServerDefault?;
    /**
     * @stability stable
     */
    get useServerDefault(): string;
    /**
     * @stability stable
     */
    set useServerDefault(value: string);
    /**
     * @stability stable
     */
    resetUseServerDefault(): void;
    /**
     * @stability stable
     */
    get useServerDefaultInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#create SqlDatabase#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#delete SqlDatabase#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#read SqlDatabase#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html#update SqlDatabase#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function sqlDatabaseTimeoutsToTerraform(struct?: SqlDatabaseTimeoutsOutputReference | SqlDatabaseTimeouts): any;
/**
 * @stability stable
 */
export declare class SqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SqlDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SqlDatabaseTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html azurerm_sql_database}.
 *
 * @stability stable
 */
export declare class SqlDatabase extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sql_database.html azurerm_sql_database} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SqlDatabaseConfig);
    private _collation?;
    /**
     * @stability stable
     */
    get collation(): string;
    /**
     * @stability stable
     */
    set collation(value: string);
    /**
     * @stability stable
     */
    resetCollation(): void;
    /**
     * @stability stable
     */
    get collationInput(): string | undefined;
    private _createMode?;
    /**
     * @stability stable
     */
    get createMode(): string;
    /**
     * @stability stable
     */
    set createMode(value: string);
    /**
     * @stability stable
     */
    resetCreateMode(): void;
    /**
     * @stability stable
     */
    get createModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get creationDate(): string;
    /**
     * @stability stable
     */
    get defaultSecondaryLocation(): string;
    private _edition?;
    /**
     * @stability stable
     */
    get edition(): string;
    /**
     * @stability stable
     */
    set edition(value: string);
    /**
     * @stability stable
     */
    resetEdition(): void;
    /**
     * @stability stable
     */
    get editionInput(): string | undefined;
    private _elasticPoolName?;
    /**
     * @stability stable
     */
    get elasticPoolName(): string;
    /**
     * @stability stable
     */
    set elasticPoolName(value: string);
    /**
     * @stability stable
     */
    resetElasticPoolName(): void;
    /**
     * @stability stable
     */
    get elasticPoolNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get encryption(): string;
    private _extendedAuditingPolicy?;
    /**
     * @stability stable
     */
    get extendedAuditingPolicy(): SqlDatabaseExtendedAuditingPolicy[];
    /**
     * @stability stable
     */
    set extendedAuditingPolicy(value: SqlDatabaseExtendedAuditingPolicy[]);
    /**
     * @stability stable
     */
    resetExtendedAuditingPolicy(): void;
    /**
     * @stability stable
     */
    get extendedAuditingPolicyInput(): SqlDatabaseExtendedAuditingPolicy[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maxSizeBytes?;
    /**
     * @stability stable
     */
    get maxSizeBytes(): string;
    /**
     * @stability stable
     */
    set maxSizeBytes(value: string);
    /**
     * @stability stable
     */
    resetMaxSizeBytes(): void;
    /**
     * @stability stable
     */
    get maxSizeBytesInput(): string | undefined;
    private _maxSizeGb?;
    /**
     * @stability stable
     */
    get maxSizeGb(): string;
    /**
     * @stability stable
     */
    set maxSizeGb(value: string);
    /**
     * @stability stable
     */
    resetMaxSizeGb(): void;
    /**
     * @stability stable
     */
    get maxSizeGbInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _readScale?;
    /**
     * @stability stable
     */
    get readScale(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set readScale(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReadScale(): void;
    /**
     * @stability stable
     */
    get readScaleInput(): boolean | cdktf.IResolvable | undefined;
    private _requestedServiceObjectiveId?;
    /**
     * @stability stable
     */
    get requestedServiceObjectiveId(): string;
    /**
     * @stability stable
     */
    set requestedServiceObjectiveId(value: string);
    /**
     * @stability stable
     */
    resetRequestedServiceObjectiveId(): void;
    /**
     * @stability stable
     */
    get requestedServiceObjectiveIdInput(): string | undefined;
    private _requestedServiceObjectiveName?;
    /**
     * @stability stable
     */
    get requestedServiceObjectiveName(): string;
    /**
     * @stability stable
     */
    set requestedServiceObjectiveName(value: string);
    /**
     * @stability stable
     */
    resetRequestedServiceObjectiveName(): void;
    /**
     * @stability stable
     */
    get requestedServiceObjectiveNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _restorePointInTime?;
    /**
     * @stability stable
     */
    get restorePointInTime(): string;
    /**
     * @stability stable
     */
    set restorePointInTime(value: string);
    /**
     * @stability stable
     */
    resetRestorePointInTime(): void;
    /**
     * @stability stable
     */
    get restorePointInTimeInput(): string | undefined;
    private _serverName?;
    /**
     * @stability stable
     */
    get serverName(): string;
    /**
     * @stability stable
     */
    set serverName(value: string);
    /**
     * @stability stable
     */
    get serverNameInput(): string | undefined;
    private _sourceDatabaseDeletionDate?;
    /**
     * @stability stable
     */
    get sourceDatabaseDeletionDate(): string;
    /**
     * @stability stable
     */
    set sourceDatabaseDeletionDate(value: string);
    /**
     * @stability stable
     */
    resetSourceDatabaseDeletionDate(): void;
    /**
     * @stability stable
     */
    get sourceDatabaseDeletionDateInput(): string | undefined;
    private _sourceDatabaseId?;
    /**
     * @stability stable
     */
    get sourceDatabaseId(): string;
    /**
     * @stability stable
     */
    set sourceDatabaseId(value: string);
    /**
     * @stability stable
     */
    resetSourceDatabaseId(): void;
    /**
     * @stability stable
     */
    get sourceDatabaseIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _zoneRedundant?;
    /**
     * @stability stable
     */
    get zoneRedundant(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetZoneRedundant(): void;
    /**
     * @stability stable
     */
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
    private _import;
    /**
     * @stability stable
     */
    get import(): SqlDatabaseImportOutputReference;
    /**
     * @stability stable
     */
    putImport(value: SqlDatabaseImport): void;
    /**
     * @stability stable
     */
    resetImport(): void;
    /**
     * @stability stable
     */
    get importInput(): SqlDatabaseImport | undefined;
    private _threatDetectionPolicy;
    /**
     * @stability stable
     */
    get threatDetectionPolicy(): SqlDatabaseThreatDetectionPolicyOutputReference;
    /**
     * @stability stable
     */
    putThreatDetectionPolicy(value: SqlDatabaseThreatDetectionPolicy): void;
    /**
     * @stability stable
     */
    resetThreatDetectionPolicy(): void;
    /**
     * @stability stable
     */
    get threatDetectionPolicyInput(): SqlDatabaseThreatDetectionPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SqlDatabaseTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SqlDatabaseTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SqlDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
