import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageShareFileConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#content_disposition StorageShareFile#content_disposition}.
     *
     * @stability stable
     */
    readonly contentDisposition?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#content_encoding StorageShareFile#content_encoding}.
     *
     * @stability stable
     */
    readonly contentEncoding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#content_md5 StorageShareFile#content_md5}.
     *
     * @stability stable
     */
    readonly contentMd5?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#content_type StorageShareFile#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#metadata StorageShareFile#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#name StorageShareFile#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#path StorageShareFile#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#source StorageShareFile#source}.
     *
     * @stability stable
     */
    readonly source?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#storage_share_id StorageShareFile#storage_share_id}.
     *
     * @stability stable
     */
    readonly storageShareId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#timeouts StorageShareFile#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageShareFileTimeouts;
}
/**
 * @stability stable
 */
export interface StorageShareFileTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#create StorageShareFile#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#delete StorageShareFile#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#read StorageShareFile#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html#update StorageShareFile#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function storageShareFileTimeoutsToTerraform(struct?: StorageShareFileTimeoutsOutputReference | StorageShareFileTimeouts): any;
/**
 * @stability stable
 */
export declare class StorageShareFileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageShareFileTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageShareFileTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html azurerm_storage_share_file}.
 *
 * @stability stable
 */
export declare class StorageShareFile extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share_file.html azurerm_storage_share_file} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageShareFileConfig);
    private _contentDisposition?;
    /**
     * @stability stable
     */
    get contentDisposition(): string;
    /**
     * @stability stable
     */
    set contentDisposition(value: string);
    /**
     * @stability stable
     */
    resetContentDisposition(): void;
    /**
     * @stability stable
     */
    get contentDispositionInput(): string | undefined;
    private _contentEncoding?;
    /**
     * @stability stable
     */
    get contentEncoding(): string;
    /**
     * @stability stable
     */
    set contentEncoding(value: string);
    /**
     * @stability stable
     */
    resetContentEncoding(): void;
    /**
     * @stability stable
     */
    get contentEncodingInput(): string | undefined;
    private _contentMd5?;
    /**
     * @stability stable
     */
    get contentMd5(): string;
    /**
     * @stability stable
     */
    set contentMd5(value: string);
    /**
     * @stability stable
     */
    resetContentMd5(): void;
    /**
     * @stability stable
     */
    get contentMd5Input(): string | undefined;
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    set contentType(value: string);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    set source(value: string);
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _storageShareId?;
    /**
     * @stability stable
     */
    get storageShareId(): string;
    /**
     * @stability stable
     */
    set storageShareId(value: string);
    /**
     * @stability stable
     */
    get storageShareIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StorageShareFileTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StorageShareFileTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageShareFileTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
