import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpnGatewayConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#internet_security_enabled VpnGatewayConnection#internet_security_enabled}.
     *
     * @stability stable
     */
    readonly internetSecurityEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#name VpnGatewayConnection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#remote_vpn_site_id VpnGatewayConnection#remote_vpn_site_id}.
     *
     * @stability stable
     */
    readonly remoteVpnSiteId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#vpn_gateway_id VpnGatewayConnection#vpn_gateway_id}.
     *
     * @stability stable
     */
    readonly vpnGatewayId: string;
    /**
     * routing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#routing VpnGatewayConnection#routing}
     *
     * @stability stable
     */
    readonly routing?: VpnGatewayConnectionRouting[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#timeouts VpnGatewayConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpnGatewayConnectionTimeouts;
    /**
     * vpn_link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#vpn_link VpnGatewayConnection#vpn_link}
     *
     * @stability stable
     */
    readonly vpnLink: VpnGatewayConnectionVpnLink[];
}
/**
 * @stability stable
 */
export interface VpnGatewayConnectionRouting {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#associated_route_table VpnGatewayConnection#associated_route_table}.
     *
     * @stability stable
     */
    readonly associatedRouteTable: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#propagated_route_tables VpnGatewayConnection#propagated_route_tables}.
     *
     * @stability stable
     */
    readonly propagatedRouteTables: string[];
}
export declare function vpnGatewayConnectionRoutingToTerraform(struct?: VpnGatewayConnectionRouting): any;
/**
 * @stability stable
 */
export interface VpnGatewayConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#create VpnGatewayConnection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#delete VpnGatewayConnection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#read VpnGatewayConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#update VpnGatewayConnection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function vpnGatewayConnectionTimeoutsToTerraform(struct?: VpnGatewayConnectionTimeoutsOutputReference | VpnGatewayConnectionTimeouts): any;
/**
 * @stability stable
 */
export declare class VpnGatewayConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnGatewayConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnGatewayConnectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VpnGatewayConnectionVpnLinkIpsecPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#dh_group VpnGatewayConnection#dh_group}.
     *
     * @stability stable
     */
    readonly dhGroup: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#encryption_algorithm VpnGatewayConnection#encryption_algorithm}.
     *
     * @stability stable
     */
    readonly encryptionAlgorithm: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#ike_encryption_algorithm VpnGatewayConnection#ike_encryption_algorithm}.
     *
     * @stability stable
     */
    readonly ikeEncryptionAlgorithm: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#ike_integrity_algorithm VpnGatewayConnection#ike_integrity_algorithm}.
     *
     * @stability stable
     */
    readonly ikeIntegrityAlgorithm: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#integrity_algorithm VpnGatewayConnection#integrity_algorithm}.
     *
     * @stability stable
     */
    readonly integrityAlgorithm: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#pfs_group VpnGatewayConnection#pfs_group}.
     *
     * @stability stable
     */
    readonly pfsGroup: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#sa_data_size_kb VpnGatewayConnection#sa_data_size_kb}.
     *
     * @stability stable
     */
    readonly saDataSizeKb: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#sa_lifetime_sec VpnGatewayConnection#sa_lifetime_sec}.
     *
     * @stability stable
     */
    readonly saLifetimeSec: number;
}
export declare function vpnGatewayConnectionVpnLinkIpsecPolicyToTerraform(struct?: VpnGatewayConnectionVpnLinkIpsecPolicy): any;
/**
 * @stability stable
 */
export interface VpnGatewayConnectionVpnLink {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#bandwidth_mbps VpnGatewayConnection#bandwidth_mbps}.
     *
     * @stability stable
     */
    readonly bandwidthMbps?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#bgp_enabled VpnGatewayConnection#bgp_enabled}.
     *
     * @stability stable
     */
    readonly bgpEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#local_azure_ip_address_enabled VpnGatewayConnection#local_azure_ip_address_enabled}.
     *
     * @stability stable
     */
    readonly localAzureIpAddressEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#name VpnGatewayConnection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#policy_based_traffic_selector_enabled VpnGatewayConnection#policy_based_traffic_selector_enabled}.
     *
     * @stability stable
     */
    readonly policyBasedTrafficSelectorEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#protocol VpnGatewayConnection#protocol}.
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#ratelimit_enabled VpnGatewayConnection#ratelimit_enabled}.
     *
     * @stability stable
     */
    readonly ratelimitEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#route_weight VpnGatewayConnection#route_weight}.
     *
     * @stability stable
     */
    readonly routeWeight?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#shared_key VpnGatewayConnection#shared_key}.
     *
     * @stability stable
     */
    readonly sharedKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#vpn_site_link_id VpnGatewayConnection#vpn_site_link_id}.
     *
     * @stability stable
     */
    readonly vpnSiteLinkId: string;
    /**
     * ipsec_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html#ipsec_policy VpnGatewayConnection#ipsec_policy}
     *
     * @stability stable
     */
    readonly ipsecPolicy?: VpnGatewayConnectionVpnLinkIpsecPolicy[];
}
export declare function vpnGatewayConnectionVpnLinkToTerraform(struct?: VpnGatewayConnectionVpnLink): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html azurerm_vpn_gateway_connection}.
 *
 * @stability stable
 */
export declare class VpnGatewayConnection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_connection.html azurerm_vpn_gateway_connection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpnGatewayConnectionConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _internetSecurityEnabled?;
    /**
     * @stability stable
     */
    get internetSecurityEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set internetSecurityEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInternetSecurityEnabled(): void;
    /**
     * @stability stable
     */
    get internetSecurityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _remoteVpnSiteId?;
    /**
     * @stability stable
     */
    get remoteVpnSiteId(): string;
    /**
     * @stability stable
     */
    set remoteVpnSiteId(value: string);
    /**
     * @stability stable
     */
    get remoteVpnSiteIdInput(): string | undefined;
    private _vpnGatewayId?;
    /**
     * @stability stable
     */
    get vpnGatewayId(): string;
    /**
     * @stability stable
     */
    set vpnGatewayId(value: string);
    /**
     * @stability stable
     */
    get vpnGatewayIdInput(): string | undefined;
    private _routing?;
    /**
     * @stability stable
     */
    get routing(): VpnGatewayConnectionRouting[];
    /**
     * @stability stable
     */
    set routing(value: VpnGatewayConnectionRouting[]);
    /**
     * @stability stable
     */
    resetRouting(): void;
    /**
     * @stability stable
     */
    get routingInput(): VpnGatewayConnectionRouting[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VpnGatewayConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpnGatewayConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpnGatewayConnectionTimeouts | undefined;
    private _vpnLink?;
    /**
     * @stability stable
     */
    get vpnLink(): VpnGatewayConnectionVpnLink[];
    /**
     * @stability stable
     */
    set vpnLink(value: VpnGatewayConnectionVpnLink[]);
    /**
     * @stability stable
     */
    get vpnLinkInput(): VpnGatewayConnectionVpnLink[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
