# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2020 Dan <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.api.core import *


class StatsGraphError(TLObject):
    """Attributes:
        LAYER: ``112``

    Attributes:
        ID: ``0xbedc9822``

    Parameters:
        error: ``str``

    See Also:
        This object can be returned by :obj:`stats.LoadAsyncGraph <pyrogram.api.functions.stats.LoadAsyncGraph>`.
    """

    __slots__ = ["error"]

    ID = 0xbedc9822
    QUALNAME = "types.StatsGraphError"

    def __init__(self, *, error: str):
        self.error = error  # string

    @staticmethod
    def read(b: BytesIO, *args) -> "StatsGraphError":
        # No flags
        
        error = String.read(b)
        
        return StatsGraphError(error=error)

    def write(self) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        # No flags
        
        b.write(String(self.error))
        
        return b.getvalue()
