# Generated by Django 5.0.6 on 2024-05-24 14:57

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Assistant",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("slug", models.CharField(max_length=255, unique=True)),
                ("name", models.CharField(blank=True, max_length=255)),
                ("openai_id", models.CharField(max_length=255, unique=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Assistant",
                "verbose_name_plural": "Assistants",
                "ordering": ("-created_at",),
                "indexes": [
                    models.Index(
                        models.OrderBy(models.F("created_at"), descending=True),
                        name="assistant_created_at_desc",
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="Thread",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("name", models.CharField(blank=True, max_length=255)),
                ("openai_id", models.CharField(max_length=255, unique=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "created_by",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="ai_assistant_threads",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Thread",
                "verbose_name_plural": "Threads",
                "ordering": ("-created_at",),
                "indexes": [
                    models.Index(
                        models.OrderBy(models.F("created_at"), descending=True),
                        name="thread_created_at_desc",
                    )
                ],
            },
        ),
    ]
