import * as React from 'react';
import { classes } from 'typestyle';
import { LabIcon } from '@jupyterlab/ui-components';
import { actionButtonStyle } from '../style/ActionButtonStyle';
/**
 * Action button component
 *
 * @param props Component properties
 */
export const ActionButton = (props) => {
    return (React.createElement("button", { disabled: props.disabled, className: classes(actionButtonStyle, props.className), title: props.title, onClick: props.onClick },
        React.createElement(LabIcon.resolveReact, { icon: props.iconName })));
};
//# sourceMappingURL=ActionButton.js.map