import * as React from 'react';
import { classes } from 'typestyle';
import { caretdownImageStyle, caretrightImageStyle, changeStageButtonStyle, sectionHeaderSizeStyle, sectionAreaStyle, sectionFileContainerStyle, sectionHeaderLabelStyle } from '../style/GitStageStyle';
export const GitStage = (props) => {
    const [showFiles, setShowFiles] = React.useState(true);
    return (React.createElement("div", { className: sectionFileContainerStyle },
        React.createElement("div", { className: sectionAreaStyle },
            props.collapsible && (React.createElement("button", { className: classes(changeStageButtonStyle, showFiles && props.nFiles > 0
                    ? caretdownImageStyle
                    : caretrightImageStyle), onClick: () => {
                    if (props.nFiles > 0) {
                        setShowFiles(!showFiles);
                    }
                } })),
            React.createElement("span", { className: sectionHeaderLabelStyle }, props.heading),
            props.actions,
            React.createElement("span", { className: sectionHeaderSizeStyle },
                "(",
                props.nFiles,
                ")")),
        showFiles && (React.createElement("ul", { className: sectionFileContainerStyle }, props.children))));
};
//# sourceMappingURL=GitStage.js.map