import { Intent } from '@blueprintjs/core';
import { IDictionary } from '@elyra/application';
import { ReactWidget } from '@jupyterlab/apputils';
import { CodeEditor, IEditorServices } from '@jupyterlab/codeeditor';
import { Message } from '@lumino/messaging';
import * as React from 'react';
interface IMetadataEditorProps {
    schema: string;
    namespace: string;
    name?: string;
    onSave: () => void;
    editorServices: IEditorServices | null;
}
/**
 * Metadata editor widget
 */
export declare class MetadataEditor extends ReactWidget {
    onSave: () => void;
    displayName: string;
    editorServices: IEditorServices;
    editor: CodeEditor.IEditor;
    schemaName: string;
    namespace: string;
    name: string;
    dirty: boolean;
    requiredFields: string[];
    invalidForm: boolean;
    schema: IDictionary<any>;
    allMetadata: IDictionary<any>[];
    metadata: IDictionary<any>;
    constructor(props: IMetadataEditorProps);
    initializeMetadata(): Promise<void>;
    /**
     * Checks that all required fields have a value before submitting the form.
     * Returns false if the form is valid. Sets any invalid fields' intent to danger
     * so that the form will highlight the input(s) causing issues in red.
     */
    hasInvalidFields(): boolean;
    onCloseRequest(msg: Message): void;
    saveMetadata(): void;
    handleTextInputChange(event: any, schemaField: string): void;
    handleDropdownChange: (schemaField: string, value: string) => void;
    handleDirtyState(dirty: boolean): void;
    onUpdateRequest(msg: Message): void;
    getDefaultChoices(fieldName: string): any[];
    renderTextInput(label: string, description: string, fieldName: string, defaultValue: string, required: string, intent?: Intent): React.ReactElement;
    renderField(fieldName: string): React.ReactElement;
    render(): React.ReactElement;
}
export {};
