import '../style/index.css';
import { JupyterFrontEnd } from '@jupyterlab/application';
import { ReactWidget } from '@jupyterlab/apputils';
import { IEditorServices } from '@jupyterlab/codeeditor';
import { IDocumentManager } from '@jupyterlab/docmanager';
import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import { Message } from '@lumino/messaging';
import { Signal } from '@lumino/signaling';
import { Widget } from '@lumino/widgets';
import React from 'react';
import { ICodeSnippet } from './CodeSnippetService';
/**
 * A widget for Code Snippets.
 */
export declare class CodeSnippetWidget extends ReactWidget {
    renderCodeSnippetsSignal: Signal<this, ICodeSnippet[]>;
    getCurrentWidget: () => Widget;
    app: JupyterFrontEnd;
    editorServices: IEditorServices;
    constructor(getCurrentWidget: () => Widget, app: JupyterFrontEnd, editorServices: IEditorServices);
    fetchData(): Promise<ICodeSnippet[]>;
    updateSnippets(): void;
    onAfterShow(msg: Message): void;
    addCodeSnippet(): void;
    openCodeSnippetEditor(args: any): void;
    render(): React.ReactElement;
}
/**
 * A namespace for CodeSnippet statics.
 */
export declare namespace CodeSnippetWidget {
    /**
     * Interface describing table of contents widget options.
     */
    interface IOptions {
        /**
         * Application document manager.
         */
        docmanager: IDocumentManager;
        /**
         * Application rendered MIME type.
         */
        rendermime: IRenderMimeRegistry;
    }
}
