import { JupyterFrontEnd } from '@jupyterlab/application';
import { ReactWidget } from '@jupyterlab/apputils';
import { DocumentRegistry, ABCWidgetFactory, DocumentWidget } from '@jupyterlab/docregistry';
import { IFileBrowserFactory } from '@jupyterlab/filebrowser';
import { Color } from '@material-ui/lab/Alert';
import 'carbon-components/css/carbon-components.min.css';
import '@elyra/canvas/dist/common-canvas.min.css';
import '../style/canvas.css';
import * as React from 'react';
interface IValidationError {
    errorMessage: string;
    errorSeverity: Color;
}
export declare const commandIDs: {
    openPipelineEditor: string;
    openDocManager: string;
    newDocManager: string;
    submitNotebook: string;
};
/**
 * Wrapper Class for Common Canvas React Component
 */
export declare class PipelineEditorWidget extends ReactWidget {
    app: JupyterFrontEnd;
    browserFactory: IFileBrowserFactory;
    context: DocumentRegistry.Context;
    constructor(props: any);
    render(): React.ReactElement;
}
/**
 * A namespace for Pipeline.
 */
export declare namespace PipelineEditor {
    /**
     * The props for PipelineEditor.
     */
    interface IProps {
        app: JupyterFrontEnd;
        browserFactory: IFileBrowserFactory;
        widgetContext: DocumentRegistry.Context;
    }
    /**
     * The props for PipelineEditor.
     */
    interface IState {
        /**
         * Whether the properties dialog is visible.
         */
        showPropertiesDialog: boolean;
        /**
         * The form contents of the properties dialog.
         */
        propertiesInfo: any;
        showValidationError: boolean;
        validationError: IValidationError;
        /**
         * Whether pipeline is empty.
         */
        emptyPipeline: boolean;
    }
}
/**
 * Class for Common Canvas React Component
 */
export declare class PipelineEditor extends React.Component<PipelineEditor.IProps, PipelineEditor.IState> {
    app: JupyterFrontEnd;
    browserFactory: IFileBrowserFactory;
    canvasController: any;
    widgetContext: DocumentRegistry.Context;
    position: number;
    node: React.RefObject<HTMLDivElement>;
    propertiesInfo: any;
    constructor(props: any);
    render(): React.ReactElement;
    updateModel(): void;
    initPropertiesInfo(): Promise<void>;
    openPropertiesDialog(source: any): void;
    applyPropertyChanges(propertySet: any, appData: any): void;
    closePropertiesDialog(): void;
    contextMenuHandler(source: any, defaultMenu: any): any;
    clickActionHandler(source: any): void;
    nodesConnected(sourceNode: string, targetNode: string, links: any[]): boolean;
    beforeEditActionHandler(data: any): any;
    editActionHandler(data: any): void;
    tipHandler(tipType: string, data: any): any;
    handleAddFileToPipelineCanvas(x?: number, y?: number): Promise<any>;
    handleOpenNotebook(selectedNodes: any): void;
    handleExportPipeline(): Promise<void>;
    handleOpenPipeline(): Promise<void>;
    /**
     * Adds an error decoration if a node has any invalid properties.
     *
     * @param node - canvas node object to validate
     *
     * @returns true if the node is valid.
     */
    validateNode(node: any): boolean;
    /**
     * Validates the properties of a given node.
     *
     * @param node: node to check properties for
     *
     * @returns a warning message to display in the tooltip
     * if there are invalid properties. If there are none,
     * returns null.
     */
    validateProperties(node: any): string;
    /**
     * Validates the properties of all nodes in the pipeline.
     * Updates the decorations / style of all nodes.
     *
     * @returns null if all nodes are valid, error message if
     * invalid.
     */
    validateAllNodes(): string;
    /**
     * Validates all links in the pipeline.
     * Updates the decorations / style of links.
     *
     * @returns null if pipeline is valid, error message if not.
     */
    validateAllLinks(): string;
    /**
     * Validates all links and nodes in the pipeline.
     * Updates the decorations / style of links and nodes.
     *
     * @returns null if pipeline is valid, error message if not.
     */
    validatePipeline(): string;
    handleRunPipeline(): Promise<void>;
    handleSavePipeline(): void;
    handleClearPipeline(data: any): Promise<any>;
    handleClosePipeline(): void;
    componentDidMount(): void;
    componentWillUnmount(): void;
    /**
     * Handle the DOM events.
     *
     * @param event - The DOM event.
     */
    handleEvent(event: Event): void;
}
export declare class PipelineEditorFactory extends ABCWidgetFactory<DocumentWidget> {
    app: JupyterFrontEnd;
    browserFactory: IFileBrowserFactory;
    constructor(options: any);
    protected createNewWidget(context: DocumentRegistry.Context): DocumentWidget;
}
export {};
