import os

from torchdrug import data, utils
from torchdrug.core import Registry as R


@R.register("datasets.Delaney")
@utils.copy_args(data.MoleculeDataset.load_csv, ignore=("smiles_field", "target_fields"))
class Delaney(data.MoleculeDataset):
    """
    Log-scale water solubility of molecules.

    Statistics:
        - #Molecule: 1,128
        - #Regression task: 1

    Parameters:
        path (str): path to store the dataset
        verbose (int, optional): output verbose level
        **kwargs
    """

    url = "http://deepchem.io.s3-website-us-west-1.amazonaws.com/datasets/delaney-processed.csv"
    md5 = "0c90a51668d446b9e3ab77e67662bd1c"
    target_fields = ["measured log solubility in mols per litre"]

    def __init__(self, path, verbose=1, **kwargs):
        path = os.path.expanduser(path)
        if not os.path.exists(path):
            os.makedirs(path)
        self.path = path

        file_name = utils.download(self.url, self.path, md5=self.md5)

        self.load_csv(file_name, smiles_field="smiles", target_fields=self.target_fields,
                      verbose=verbose, **kwargs)