import os

from torchdrug import data, utils
from torchdrug.core import Registry as R


@R.register("datasets.FreeSolv")
@utils.copy_args(data.MoleculeDataset.load_csv, ignore=("smiles_field", "target_fields"))
class FreeSolv(data.MoleculeDataset):
    """
    Experimental and calculated hydration free energy of small molecules in water.

    Statistics:
        - #Molecule: 642
        - #Regression task: 1

    Parameters:
        path (str): path to store the dataset
        verbose (int, optional): output verbose level
        **kwargs
    """

    url = "https://s3-us-west-1.amazonaws.com/deepchem.io/datasets/molnet_publish/FreeSolv.zip"
    md5 = "8d681babd239b15e2f8b2d29f025577a"
    target_fields = ["expt"]

    def __init__(self, path, verbose=1, **kwargs):
        path = os.path.expanduser(path)
        if not os.path.exists(path):
            os.makedirs(path)
        self.path = path

        zip_file = utils.download(self.url, self.path, md5=self.md5)
        csv_file = utils.extract(zip_file, "SAMPL.csv")

        self.load_csv(csv_file, smiles_field="smiles", target_fields=self.target_fields,
                      verbose=verbose, **kwargs)