// pmx  Copyright Notice
// ============================
//
// The pmx source code is copyrighted, but you can freely use and
// copy it as long as you don't change or remove any of the copyright
// notices.
//
// ----------------------------------------------------------------------
// pmx is Copyright (C) 2006-2011 by Daniel Seeliger
//
//                        All Rights Reserved
//
// Permission to use, copy, modify, distribute, and distribute modified
// versions of this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both the copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of Daniel Seeliger not be used in advertising or publicity
// pertaining to distribution of the software without specific, written
// prior permission.
//
// DANIEL SEELIGER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
// SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS.  IN NO EVENT SHALL DANIEL SEELIGER BE LIABLE FOR ANY
// SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
// RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
// CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
// CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
// ----------------------------------------------------------------------

#ifndef PYMACS_H
#define PYMACS_H
#include <Python.h>

#define XX 0
#define YY 1
#define ZZ 2
#define DIM 3

typedef double real;
typedef real            rvec[DIM];
typedef double          dvec[DIM];
typedef real            matrix[DIM][DIM];
typedef real            tensor[DIM][DIM];
typedef int             ivec[DIM];
typedef int             imatrix[DIM][DIM];
typedef int             bool;


// to support python 3
 #if PY_MAJOR_VERSION >= 3
    #define PyInt_FromLong PyLong_FromLong
    #define PyInt_AsLong PyLong_AsLong
    #define PyString_FromString PyUnicode_FromString
    #define PyString_AsString PyBytes_AsString
 #endif


#define M_PI        3.14159265358979323846
#define RAD2DEG          (180.0/M_PI)           /* Conversion   */
#define DEG2RAD          (M_PI/180.0)           /* id           */

#define TRUE             1
#define FALSE            0

#define CCONTR   0.9
#define HCONTR   0.35
#define NCONTR   0.9
#define OCONTR   0.9
#define SCONTR   1.1
#define PCONTR   1.1
#define MCONTR   1.5
#define ICONTR   1.5
#define FCONTR   0.7
#define CLCONTR  1.0
#define BRCONTR  1.25


void PyObject2rvec( PyObject *o, rvec *x, int natoms);
PyObject* rvec2PyObject( rvec *x, int natoms);
PyObject* matrix2PyObject( matrix R);
void PyObject2real_array( PyObject *o, real *arr, int natoms);
void PyObject2matrix( PyObject *o, matrix R);
void Pyvec2rvec( PyObject *Ox, rvec x);


PyObject *wrap_dist(PyObject *self,PyObject *args);
PyObject *wrap_distance2(PyObject *self,PyObject *args);
PyObject *wrap_angle_ijk(PyObject *self,PyObject *args);
PyObject *wrap_dihedral(PyObject *self,PyObject *args);
PyObject *wrap_planarity(PyObject *self,PyObject *args);
PyObject *wrap_fit(PyObject *self,PyObject *args);
PyObject *wrap_calc_fit_R(PyObject *self,PyObject *args);
PyObject *wrap_center_vec( PyObject *self, PyObject *args);
PyObject *wrap_read_stx_conf( PyObject *self, PyObject *args);
PyObject *wrap_write_conf( PyObject *self, PyObject *args);
PyObject *wrap_cryst1_to_box( PyObject *self, PyObject *args);
PyObject *wrap_box_to_cryst1( PyObject *self, PyObject *args);
PyObject *wrap_search_neighbors( PyObject *self, PyObject *args);

PyObject *wrap_calc_lj_energy(PyObject *self, PyObject *args);
PyObject *wrap_calc_coulomb_energy(PyObject *self, PyObject *args);
PyObject *wrap_calc_bond_energy(PyObject *self, PyObject *args);
PyObject *wrap_calc_angle_energy(PyObject *self, PyObject *args);
PyObject *wrap_calc_dihedral_energy(PyObject *self, PyObject *args);
PyObject *wrap_calc_improper_energy(PyObject *self, PyObject *args);

PyObject *wrap_total_bond_energy(PyObject *self, PyObject *args);
PyObject *wrap_total_angle_energy(PyObject *self, PyObject *args);
PyObject *wrap_total_dihedral_energy(PyObject *self, PyObject *args);
PyObject *wrap_total_improper_energy(PyObject *self, PyObject *args);

PyObject *wrap_nb_lj_energy(PyObject *self, PyObject *args);
PyObject *wrap_nb_coul_energy(PyObject *self, PyObject *args);
PyObject *wrap_lj14_energy(PyObject *self, PyObject *args);
PyObject *wrap_coul14_energy(PyObject *self, PyObject *args);
PyObject *wrap_nb_energy(PyObject *self, PyObject *args);
PyObject *apply_rotation( PyObject *self, PyObject *args);

#endif
