"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import sys
import typing
import vdp.pipeline.v1beta.common_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ConnectorType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ConnectorTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ConnectorType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CONNECTOR_TYPE_UNSPECIFIED: _ConnectorType.ValueType  # 0
    """Unspecified."""
    CONNECTOR_TYPE_SOURCE: _ConnectorType.ValueType  # 1
    """Source connector."""
    CONNECTOR_TYPE_DESTINATION: _ConnectorType.ValueType  # 2
    """Destination connector."""
    CONNECTOR_TYPE_AI: _ConnectorType.ValueType  # 3
    """AI connector."""
    CONNECTOR_TYPE_BLOCKCHAIN: _ConnectorType.ValueType  # 4
    """Blockchain connector."""
    CONNECTOR_TYPE_DATA: _ConnectorType.ValueType  # 5
    """Data connector."""
    CONNECTOR_TYPE_OPERATOR: _ConnectorType.ValueType  # 6
    """Operator connector."""

class ConnectorType(_ConnectorType, metaclass=_ConnectorTypeEnumTypeWrapper):
    """////////////////////////////////////////////////////////////////////////

    ConnectorType defines the connector type based on its task features.
    """

CONNECTOR_TYPE_UNSPECIFIED: ConnectorType.ValueType  # 0
"""Unspecified."""
CONNECTOR_TYPE_SOURCE: ConnectorType.ValueType  # 1
"""Source connector."""
CONNECTOR_TYPE_DESTINATION: ConnectorType.ValueType  # 2
"""Destination connector."""
CONNECTOR_TYPE_AI: ConnectorType.ValueType  # 3
"""AI connector."""
CONNECTOR_TYPE_BLOCKCHAIN: ConnectorType.ValueType  # 4
"""Blockchain connector."""
CONNECTOR_TYPE_DATA: ConnectorType.ValueType  # 5
"""Data connector."""
CONNECTOR_TYPE_OPERATOR: ConnectorType.ValueType  # 6
"""Operator connector."""
global___ConnectorType = ConnectorType

@typing_extensions.final
class ConnectorSpec(google.protobuf.message.Message):
    """//////////////////////////////////

    ConnectorSpec represents a specification data model.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_SPECIFICATION_FIELD_NUMBER: builtins.int
    COMPONENT_SPECIFICATION_FIELD_NUMBER: builtins.int
    OPENAPI_SPECIFICATIONS_FIELD_NUMBER: builtins.int
    @property
    def resource_specification(self) -> google.protobuf.struct_pb2.Struct:
        """Resource specification."""
    @property
    def component_specification(self) -> google.protobuf.struct_pb2.Struct:
        """Component specification."""
    @property
    def openapi_specifications(self) -> google.protobuf.struct_pb2.Struct:
        """OpenAPI specification."""
    def __init__(
        self,
        *,
        resource_specification: google.protobuf.struct_pb2.Struct | None = ...,
        component_specification: google.protobuf.struct_pb2.Struct | None = ...,
        openapi_specifications: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["component_specification", b"component_specification", "openapi_specifications", b"openapi_specifications", "resource_specification", b"resource_specification"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["component_specification", b"component_specification", "openapi_specifications", b"openapi_specifications", "resource_specification", b"resource_specification"]) -> None: ...

global___ConnectorSpec = ConnectorSpec

@typing_extensions.final
class ConnectorDefinition(google.protobuf.message.Message):
    """A Connector is a type of pipeline component that queries, processes or sends
    the ingested unstructured data to a service or app. Users need to configure
    their connectors (e.g. by providing an API token to a remote service). A
    ConnectorDefinition describes a certain type of Connector.

    For more information, see
    [Component](https://www.instill.tech/docs/latest/core/concepts/pipeline#pipeline-component)
    in the official documentation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _View:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ConnectorDefinition._View.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VIEW_UNSPECIFIED: ConnectorDefinition._View.ValueType  # 0
        """Unspecified, equivalent to BASIC."""
        VIEW_BASIC: ConnectorDefinition._View.ValueType  # 1
        """Default view, only includes basic information (removes the `spec`
        field).
        """
        VIEW_FULL: ConnectorDefinition._View.ValueType  # 2
        """Full representation."""

    class View(_View, metaclass=_ViewEnumTypeWrapper):
        """View defines how a connector definition is presented."""

    VIEW_UNSPECIFIED: ConnectorDefinition.View.ValueType  # 0
    """Unspecified, equivalent to BASIC."""
    VIEW_BASIC: ConnectorDefinition.View.ValueType  # 1
    """Default view, only includes basic information (removes the `spec`
    field).
    """
    VIEW_FULL: ConnectorDefinition.View.ValueType  # 2
    """Full representation."""

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DOCUMENTATION_URL_FIELD_NUMBER: builtins.int
    ICON_FIELD_NUMBER: builtins.int
    SPEC_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    TOMBSTONE_FIELD_NUMBER: builtins.int
    PUBLIC_FIELD_NUMBER: builtins.int
    CUSTOM_FIELD_NUMBER: builtins.int
    VENDOR_FIELD_NUMBER: builtins.int
    VENDOR_ATTRIBUTES_FIELD_NUMBER: builtins.int
    SOURCE_URL_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    TASKS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the connector definition, defined by its ID.
    - Format: `connector-definitions/{id}
    """
    uid: builtins.str
    """Connector definition UUID."""
    id: builtins.str
    """Connector definition resource ID (used in `name` as the last segment). This
    conforms to RFC-1034, which restricts to letters, numbers, and hyphen,
    with the first character a letter, the last a letter or a number, and a 63
    character maximum.
    """
    title: builtins.str
    """Connector definition title."""
    documentation_url: builtins.str
    """Connector definition documentation URL."""
    icon: builtins.str
    """Connector definition icon. This is a path that's relative to the root of
    the connector implementation (see `source_url`) and that allows clients
    frontend applications to pull and locate the icons.
    """
    @property
    def spec(self) -> global___ConnectorSpec:
        """Connector definition specification."""
    type: global___ConnectorType.ValueType
    """Connector definition type."""
    tombstone: builtins.bool
    """Connector definition tombstone. If true, this configuration is permanently
    off. Otherwise, the configuration is active.
    """
    public: builtins.bool
    """The public flag determines whether this connector definition is available
    to all workspaces.
    """
    custom: builtins.bool
    """Connector definition custom flag, i.e., whether this is a custom
    connector definition.
    """
    vendor: builtins.str
    """Connector definition vendor name."""
    @property
    def vendor_attributes(self) -> google.protobuf.struct_pb2.Struct:
        """Vendor-specific attributes."""
    source_url: builtins.str
    """Source code URL. This points to the source code where the connector is
    implemented.
    """
    version: builtins.str
    """Connector definition version. This is a string that fulfills the SemVer
    specification (e.g. `1.0.0-beta`).
    """
    @property
    def tasks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[vdp.pipeline.v1beta.common_pb2.ComponentTask]:
        """List of tasks that can be executed by the connector."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        title: builtins.str = ...,
        documentation_url: builtins.str = ...,
        icon: builtins.str = ...,
        spec: global___ConnectorSpec | None = ...,
        type: global___ConnectorType.ValueType = ...,
        tombstone: builtins.bool = ...,
        public: builtins.bool = ...,
        custom: builtins.bool = ...,
        vendor: builtins.str = ...,
        vendor_attributes: google.protobuf.struct_pb2.Struct | None = ...,
        source_url: builtins.str = ...,
        version: builtins.str = ...,
        tasks: collections.abc.Iterable[vdp.pipeline.v1beta.common_pb2.ComponentTask] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["spec", b"spec", "vendor_attributes", b"vendor_attributes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["custom", b"custom", "documentation_url", b"documentation_url", "icon", b"icon", "id", b"id", "name", b"name", "public", b"public", "source_url", b"source_url", "spec", b"spec", "tasks", b"tasks", "title", b"title", "tombstone", b"tombstone", "type", b"type", "uid", b"uid", "vendor", b"vendor", "vendor_attributes", b"vendor_attributes", "version", b"version"]) -> None: ...

global___ConnectorDefinition = ConnectorDefinition

@typing_extensions.final
class ListConnectorDefinitionsRequest(google.protobuf.message.Message):
    """/////////////////////////////////////////////////////////////////////
    RPC messages
    /////////////////////////////////////////////////////////////////////

    ListConnectorDefinitionsRequest represents a request to list connector
    definitions.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of connector definitions to return. If this parameter
    is unspecified, at most 10 pipelines will be returned. The cap value for
    this parameter is 100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page token."""
    view: global___ConnectorDefinition.View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    filter: builtins.str
    """Filter can hold an [AIP-160](https://google.aip.dev/160)-compliant filter
    expression.
    - Example: `create_time>timestamp("2000-06-19T23:31:08.657Z")`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        view: global___ConnectorDefinition.View.ValueType | None = ...,
        filter: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_filter", b"_filter", "_page_size", b"_page_size", "_page_token", b"_page_token", "_view", b"_view", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_filter", b"_filter"]) -> typing_extensions.Literal["filter"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___ListConnectorDefinitionsRequest = ListConnectorDefinitionsRequest

@typing_extensions.final
class ListConnectorDefinitionsResponse(google.protobuf.message.Message):
    """ListConnectorDefinitionsResponse contains a list of connector definitions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_DEFINITIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def connector_definitions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConnectorDefinition]:
        """A list of connector definition resources."""
    next_page_token: builtins.str
    """Next page token."""
    total_size: builtins.int
    """Total number of connector definitions."""
    def __init__(
        self,
        *,
        connector_definitions: collections.abc.Iterable[global___ConnectorDefinition] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector_definitions", b"connector_definitions", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListConnectorDefinitionsResponse = ListConnectorDefinitionsResponse

@typing_extensions.final
class GetConnectorDefinitionRequest(google.protobuf.message.Message):
    """GetConnectorDefinitionRequest represents a request to fetch the details of a
    connector definition.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the connector definition, which allows its access by ID.
    - Format: `connector-definitions/{id}`.
    """
    view: global___ConnectorDefinition.View.ValueType
    """View allows clients to specify the desired resource view in the response."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        view: global___ConnectorDefinition.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "name", b"name", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___GetConnectorDefinitionRequest = GetConnectorDefinitionRequest

@typing_extensions.final
class GetConnectorDefinitionResponse(google.protobuf.message.Message):
    """GetConnectorDefinitionResponse contains the requested connector definition."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_DEFINITION_FIELD_NUMBER: builtins.int
    @property
    def connector_definition(self) -> global___ConnectorDefinition:
        """The connector definition resource."""
    def __init__(
        self,
        *,
        connector_definition: global___ConnectorDefinition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector_definition", b"connector_definition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector_definition", b"connector_definition"]) -> None: ...

global___GetConnectorDefinitionResponse = GetConnectorDefinitionResponse

@typing_extensions.final
class LookUpConnectorDefinitionAdminRequest(google.protobuf.message.Message):
    """LookUpConnectorDefinitionAdminRequest represents a request by an admin to
    query a connector definition by its UID.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMALINK_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    permalink: builtins.str
    """The permalink of the connector definition, which allows its access by UID.
    - Format: `connector-definitions/{uid}`
    """
    view: global___ConnectorDefinition.View.ValueType
    """View allows clients to specify the desired connector definition view in
    the response.
    """
    def __init__(
        self,
        *,
        permalink: builtins.str = ...,
        view: global___ConnectorDefinition.View.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_view", b"_view", "view", b"view"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_view", b"_view", "permalink", b"permalink", "view", b"view"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_view", b"_view"]) -> typing_extensions.Literal["view"] | None: ...

global___LookUpConnectorDefinitionAdminRequest = LookUpConnectorDefinitionAdminRequest

@typing_extensions.final
class LookUpConnectorDefinitionAdminResponse(google.protobuf.message.Message):
    """LookUpConnectorDefinitionAdminResponse represents a response for a
    connector definition.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTOR_DEFINITION_FIELD_NUMBER: builtins.int
    @property
    def connector_definition(self) -> global___ConnectorDefinition:
        """The requested connector."""
    def __init__(
        self,
        *,
        connector_definition: global___ConnectorDefinition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connector_definition", b"connector_definition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["connector_definition", b"connector_definition"]) -> None: ...

global___LookUpConnectorDefinitionAdminResponse = LookUpConnectorDefinitionAdminResponse
