"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bundling = exports.DEFAULT_ASSET_EXCLUDES = exports.HASHABLE_DEPENDENCIES_EXCLUDE = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("node:path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
exports.HASHABLE_DEPENDENCIES_EXCLUDE = ['*.pyc'];
exports.DEFAULT_ASSET_EXCLUDES = [
    '.venv/',
    'node_modules/',
    'cdk.out/',
    '.git/',
    'cdk',
];
/**
 * Bundling options for Python Lambda assets
 */
class Bundling {
    static bundle(options) {
        return aws_lambda_1.Code.fromAsset(options.rootDir, {
            assetHashType: aws_cdk_lib_1.AssetHashType.SOURCE,
            exclude: exports.HASHABLE_DEPENDENCIES_EXCLUDE,
            bundling: new Bundling(options),
        });
    }
    constructor(props) {
        const { rootDir, workspacePackage, image, commandHooks, assetExcludes = exports.DEFAULT_ASSET_EXCLUDES, } = props;
        const bundlingCommands = props.skip ? [] : this.createBundlingCommands({
            rootDir,
            workspacePackage,
            assetExcludes,
            commandHooks,
            inputDir: aws_cdk_lib_1.AssetStaging.BUNDLING_INPUT_DIR,
            outputDir: aws_cdk_lib_1.AssetStaging.BUNDLING_OUTPUT_DIR,
        });
        this.image = image ?? this.createDockerImage(props);
        this.command = props.command ?? [
            'bash',
            '-c',
            bundlingCommands.join(' && '),
        ];
        this.entrypoint = props.entrypoint;
        this.volumes = props.volumes;
        this.volumesFrom = props.volumesFrom;
        this.environment = props.environment;
        this.workingDirectory = props.workingDirectory;
        this.user = props.user;
        this.securityOpt = props.securityOpt;
        this.network = props.network;
        this.bundlingFileAccess = props.bundlingFileAccess;
    }
    createDockerImage(props) {
        // If skip is true then don't call DockerImage.fromBuild as that calls dockerExec.
        // Return a dummy object of the right type as it's not going to be used.
        if (props.skip) {
            return new aws_cdk_lib_1.DockerImage('skipped');
        }
        return aws_cdk_lib_1.DockerImage.fromBuild(path.resolve(__dirname, '..', 'resources'), {
            buildArgs: {
                ...props.buildArgs,
                IMAGE: props.runtime.bundlingImage.image,
            },
            platform: (props.architecture ?? aws_lambda_1.Architecture.ARM_64).dockerPlatform,
        });
    }
    createBundlingCommands(options) {
        const excludeArgs = options.assetExcludes.map((exclude) => `--exclude="${exclude}"`);
        const workspacePackage = options.workspacePackage;
        const uvCommonArgs = `--directory ${options.outputDir}`;
        const uvPackageArgs = workspacePackage ? `--package ${workspacePackage}` : '';
        const reqsFile = `/tmp/requirements${workspacePackage || ''}.txt`;
        const commands = [];
        commands.push(...options.commandHooks?.beforeBundling(options.inputDir, options.outputDir) ?? []);
        commands.push(...[
            `rsync -rLv ${excludeArgs.join(' ')} ${options.inputDir}/ ${options.outputDir}`,
            `cd ${options.outputDir}`, // uv pip install needs to be run from here for editable deps to relative paths to be resolved
            `uv sync ${uvCommonArgs} ${uvPackageArgs} --python-preference=only-system --compile-bytecode --no-dev --frozen --no-editable --link-mode=copy`,
            `uv export ${uvCommonArgs} ${uvPackageArgs} --no-dev --frozen --no-editable > ${reqsFile}`,
            `uv pip install -r ${reqsFile} --target ${options.outputDir} --reinstall --compile-bytecode --link-mode=copy`,
            `rm -rf ${options.outputDir}/.venv`,
        ]);
        commands.push(...options.commandHooks?.afterBundling(options.inputDir, options.outputDir) ?? []);
        return commands;
    }
}
exports.Bundling = Bundling;
_a = JSII_RTTI_SYMBOL_1;
Bundling[_a] = { fqn: "uv-python-lambda.Bundling", version: "0.0.3" };
//# sourceMappingURL=data:application/json;base64,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