# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDictionariesResult',
    'AwaitableGetDictionariesResult',
    'get_dictionaries',
    'get_dictionaries_output',
]

@pulumi.output_type
class GetDictionariesResult:
    """
    A collection of values returned by getDictionaries.
    """
    def __init__(__self__, dictionaries=None, id=None, service_id=None, service_version=None):
        if dictionaries and not isinstance(dictionaries, list):
            raise TypeError("Expected argument 'dictionaries' to be a list")
        pulumi.set(__self__, "dictionaries", dictionaries)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)
        if service_version and not isinstance(service_version, int):
            raise TypeError("Expected argument 'service_version' to be a int")
        pulumi.set(__self__, "service_version", service_version)

    @property
    @pulumi.getter
    def dictionaries(self) -> Sequence['outputs.GetDictionariesDictionaryResult']:
        """
        List of all dictionaries for the version of the service.
        """
        return pulumi.get(self, "dictionaries")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> str:
        """
        Alphanumeric string identifying the service.
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> int:
        """
        Integer identifying a service version.
        """
        return pulumi.get(self, "service_version")


class AwaitableGetDictionariesResult(GetDictionariesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDictionariesResult(
            dictionaries=self.dictionaries,
            id=self.id,
            service_id=self.service_id,
            service_version=self.service_version)


def get_dictionaries(service_id: Optional[str] = None,
                     service_version: Optional[int] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDictionariesResult:
    """
    Use this data source to get a list of [Fastly dictionaries](https://developer.fastly.com/reference/api/dictionaries/) for the specified service/version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    example_service_vcl = fastly.ServiceVcl("example",
        name="Example Service",
        domains=[{
            "name": "example.com",
        }],
        dictionaries=[
            {
                "name": "example_1",
            },
            {
                "name": "example_2",
            },
            {
                "name": "example_3",
            },
        ],
        force_destroy=True)
    example = fastly.get_dictionaries_output(service_id=example_service_vcl.id,
        service_version=example_service_vcl.active_version)
    pulumi.export("serviceDictionaries", example)
    ```

    [1]: https://developer.fastly.com/reference/api/dictionaries/


    :param str service_id: Alphanumeric string identifying the service.
    :param int service_version: Integer identifying a service version.
    """
    __args__ = dict()
    __args__['serviceId'] = service_id
    __args__['serviceVersion'] = service_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('fastly:index/getDictionaries:getDictionaries', __args__, opts=opts, typ=GetDictionariesResult).value

    return AwaitableGetDictionariesResult(
        dictionaries=pulumi.get(__ret__, 'dictionaries'),
        id=pulumi.get(__ret__, 'id'),
        service_id=pulumi.get(__ret__, 'service_id'),
        service_version=pulumi.get(__ret__, 'service_version'))
def get_dictionaries_output(service_id: Optional[pulumi.Input[str]] = None,
                            service_version: Optional[pulumi.Input[int]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDictionariesResult]:
    """
    Use this data source to get a list of [Fastly dictionaries](https://developer.fastly.com/reference/api/dictionaries/) for the specified service/version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    example_service_vcl = fastly.ServiceVcl("example",
        name="Example Service",
        domains=[{
            "name": "example.com",
        }],
        dictionaries=[
            {
                "name": "example_1",
            },
            {
                "name": "example_2",
            },
            {
                "name": "example_3",
            },
        ],
        force_destroy=True)
    example = fastly.get_dictionaries_output(service_id=example_service_vcl.id,
        service_version=example_service_vcl.active_version)
    pulumi.export("serviceDictionaries", example)
    ```

    [1]: https://developer.fastly.com/reference/api/dictionaries/


    :param str service_id: Alphanumeric string identifying the service.
    :param int service_version: Integer identifying a service version.
    """
    __args__ = dict()
    __args__['serviceId'] = service_id
    __args__['serviceVersion'] = service_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('fastly:index/getDictionaries:getDictionaries', __args__, opts=opts, typ=GetDictionariesResult)
    return __ret__.apply(lambda __response__: GetDictionariesResult(
        dictionaries=pulumi.get(__response__, 'dictionaries'),
        id=pulumi.get(__response__, 'id'),
        service_id=pulumi.get(__response__, 'service_id'),
        service_version=pulumi.get(__response__, 'service_version')))
