/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuditLogSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The set of configuration fields corresponding to the value defined for `integration_key`. Refer to the `formVariables` field in the corresponding `integrations/<integration_key>/manifest.json` file in [this repo](https://github.com/launchdarkly/integration-framework/tree/master/integrations) for a full list of fields for the integration you wish to configure. **IMPORTANT**: Please note that Terraform will only accept these in snake case, regardless of the case shown in the manifest.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#config AuditLogSubscription#config}
    */
    readonly config: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#id AuditLogSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The integration key. Supported integration keys are `cloudtrail`, `datadog`, `dynatrace`, `elastic`, `grafana`, `honeycomb`, `logdna`, `msteams`, `new-relic-apm`, `signalfx`, `slack`, and `splunk`. A change in this field will force the destruction of the existing resource and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#integration_key AuditLogSubscription#integration_key}
    */
    readonly integrationKey: string;
    /**
    * A human-friendly name for your audit log subscription viewable from within the LaunchDarkly Integrations page.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#name AuditLogSubscription#name}
    */
    readonly name: string;
    /**
    * Whether or not you want your subscription enabled, i.e. to actively send events.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#on AuditLogSubscription#on}
    */
    readonly on: boolean | cdktf.IResolvable;
    /**
    * Tags associated with your resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#tags AuditLogSubscription#tags}
    */
    readonly tags?: string[];
    /**
    * statements block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#statements AuditLogSubscription#statements}
    */
    readonly statements: AuditLogSubscriptionStatements[] | cdktf.IResolvable;
}
export interface AuditLogSubscriptionStatements {
    /**
    * The list of action specifiers defining the actions to which the statement applies.
    * Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#actions AuditLogSubscription#actions}
    */
    readonly actions?: string[];
    /**
    * Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#effect AuditLogSubscription#effect}
    */
    readonly effect: string;
    /**
    * The list of action specifiers defining the actions to which the statement does not apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#not_actions AuditLogSubscription#not_actions}
    */
    readonly notActions?: string[];
    /**
    * The list of resource specifiers defining the resources to which the statement does not apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#not_resources AuditLogSubscription#not_resources}
    */
    readonly notResources?: string[];
    /**
    * The list of resource specifiers defining the resources to which the statement applies.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#resources AuditLogSubscription#resources}
    */
    readonly resources?: string[];
}
export declare function auditLogSubscriptionStatementsToTerraform(struct?: AuditLogSubscriptionStatements | cdktf.IResolvable): any;
export declare class AuditLogSubscriptionStatementsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AuditLogSubscriptionStatements | cdktf.IResolvable | undefined;
    set internalValue(value: AuditLogSubscriptionStatements | cdktf.IResolvable | undefined);
    private _actions?;
    get actions(): string[];
    set actions(value: string[]);
    resetActions(): void;
    get actionsInput(): string[] | undefined;
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _notActions?;
    get notActions(): string[];
    set notActions(value: string[]);
    resetNotActions(): void;
    get notActionsInput(): string[] | undefined;
    private _notResources?;
    get notResources(): string[];
    set notResources(value: string[]);
    resetNotResources(): void;
    get notResourcesInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
}
export declare class AuditLogSubscriptionStatementsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AuditLogSubscriptionStatements[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AuditLogSubscriptionStatementsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription launchdarkly_audit_log_subscription}
*/
export declare class AuditLogSubscription extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_audit_log_subscription";
    /**
    * Generates CDKTF code for importing a AuditLogSubscription resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuditLogSubscription to import
    * @param importFromId The id of the existing AuditLogSubscription that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuditLogSubscription to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/resources/audit_log_subscription launchdarkly_audit_log_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuditLogSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: AuditLogSubscriptionConfig);
    private _config?;
    get config(): {
        [key: string]: string;
    };
    set config(value: {
        [key: string]: string;
    });
    get configInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integrationKey?;
    get integrationKey(): string;
    set integrationKey(value: string);
    get integrationKeyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _on?;
    get on(): boolean | cdktf.IResolvable;
    set on(value: boolean | cdktf.IResolvable);
    get onInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _statements;
    get statements(): AuditLogSubscriptionStatementsList;
    putStatements(value: AuditLogSubscriptionStatements[] | cdktf.IResolvable): void;
    get statementsInput(): cdktf.IResolvable | AuditLogSubscriptionStatements[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
