/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLaunchdarklyAuditLogSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The audit log subscription ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/audit_log_subscription#id DataLaunchdarklyAuditLogSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * The integration key. Supported integration keys are `cloudtrail`, `datadog`, `dynatrace`, `elastic`, `grafana`, `honeycomb`, `logdna`, `msteams`, `new-relic-apm`, `signalfx`, `slack`, and `splunk`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/audit_log_subscription#integration_key DataLaunchdarklyAuditLogSubscription#integration_key}
    */
    readonly integrationKey: string;
}
export interface DataLaunchdarklyAuditLogSubscriptionStatements {
}
export declare function dataLaunchdarklyAuditLogSubscriptionStatementsToTerraform(struct?: DataLaunchdarklyAuditLogSubscriptionStatements): any;
export declare class DataLaunchdarklyAuditLogSubscriptionStatementsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyAuditLogSubscriptionStatements | undefined;
    set internalValue(value: DataLaunchdarklyAuditLogSubscriptionStatements | undefined);
    get actions(): string[];
    get effect(): string;
    get notActions(): string[];
    get notResources(): string[];
    get resources(): string[];
}
export declare class DataLaunchdarklyAuditLogSubscriptionStatementsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyAuditLogSubscriptionStatementsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/audit_log_subscription launchdarkly_audit_log_subscription}
*/
export declare class DataLaunchdarklyAuditLogSubscription extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "launchdarkly_audit_log_subscription";
    /**
    * Generates CDKTF code for importing a DataLaunchdarklyAuditLogSubscription resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataLaunchdarklyAuditLogSubscription to import
    * @param importFromId The id of the existing DataLaunchdarklyAuditLogSubscription that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/audit_log_subscription#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataLaunchdarklyAuditLogSubscription to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/audit_log_subscription launchdarkly_audit_log_subscription} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLaunchdarklyAuditLogSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: DataLaunchdarklyAuditLogSubscriptionConfig);
    private _config;
    get config(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _integrationKey?;
    get integrationKey(): string;
    set integrationKey(value: string);
    get integrationKeyInput(): string | undefined;
    get name(): string;
    get on(): cdktf.IResolvable;
    private _statements;
    get statements(): DataLaunchdarklyAuditLogSubscriptionStatementsList;
    get tags(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
