/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLaunchdarklyEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/environment#id DataLaunchdarklyEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The project-unique key for the environment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/environment#key DataLaunchdarklyEnvironment#key}
    */
    readonly key: string;
    /**
    * The environment's project key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/environment#project_key DataLaunchdarklyEnvironment#project_key}
    */
    readonly projectKey: string;
}
export interface DataLaunchdarklyEnvironmentApprovalSettings {
}
export declare function dataLaunchdarklyEnvironmentApprovalSettingsToTerraform(struct?: DataLaunchdarklyEnvironmentApprovalSettings): any;
export declare class DataLaunchdarklyEnvironmentApprovalSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyEnvironmentApprovalSettings | undefined;
    set internalValue(value: DataLaunchdarklyEnvironmentApprovalSettings | undefined);
    get canApplyDeclinedChanges(): cdktf.IResolvable;
    get canReviewOwnRequest(): cdktf.IResolvable;
    get minNumApprovals(): number;
    get required(): cdktf.IResolvable;
    get requiredApprovalTags(): string[];
}
export declare class DataLaunchdarklyEnvironmentApprovalSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyEnvironmentApprovalSettingsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/environment launchdarkly_environment}
*/
export declare class DataLaunchdarklyEnvironment extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "launchdarkly_environment";
    /**
    * Generates CDKTF code for importing a DataLaunchdarklyEnvironment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataLaunchdarklyEnvironment to import
    * @param importFromId The id of the existing DataLaunchdarklyEnvironment that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/environment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataLaunchdarklyEnvironment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/environment launchdarkly_environment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLaunchdarklyEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: DataLaunchdarklyEnvironmentConfig);
    get apiKey(): string;
    private _approvalSettings;
    get approvalSettings(): DataLaunchdarklyEnvironmentApprovalSettingsList;
    get clientSideId(): string;
    get color(): string;
    get confirmChanges(): cdktf.IResolvable;
    get defaultTrackEvents(): cdktf.IResolvable;
    get defaultTtl(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get mobileKey(): string;
    get name(): string;
    private _projectKey?;
    get projectKey(): string;
    set projectKey(value: string);
    get projectKeyInput(): string | undefined;
    get requireComments(): cdktf.IResolvable;
    get secureMode(): cdktf.IResolvable;
    get tags(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
