/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLaunchdarklyFeatureFlagEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The environment key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/feature_flag_environment#env_key DataLaunchdarklyFeatureFlagEnvironment#env_key}
    */
    readonly envKey: string;
    /**
    * The feature flag's unique `id` in the format `project_key/flag_key`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/feature_flag_environment#flag_id DataLaunchdarklyFeatureFlagEnvironment#flag_id}
    */
    readonly flagId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/feature_flag_environment#id DataLaunchdarklyFeatureFlagEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataLaunchdarklyFeatureFlagEnvironmentContextTargets {
}
export declare function dataLaunchdarklyFeatureFlagEnvironmentContextTargetsToTerraform(struct?: DataLaunchdarklyFeatureFlagEnvironmentContextTargets): any;
export declare class DataLaunchdarklyFeatureFlagEnvironmentContextTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyFeatureFlagEnvironmentContextTargets | undefined;
    set internalValue(value: DataLaunchdarklyFeatureFlagEnvironmentContextTargets | undefined);
    get contextKind(): string;
    get values(): string[];
    get variation(): number;
}
export declare class DataLaunchdarklyFeatureFlagEnvironmentContextTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyFeatureFlagEnvironmentContextTargetsOutputReference;
}
export interface DataLaunchdarklyFeatureFlagEnvironmentFallthrough {
}
export declare function dataLaunchdarklyFeatureFlagEnvironmentFallthroughToTerraform(struct?: DataLaunchdarklyFeatureFlagEnvironmentFallthrough): any;
export declare class DataLaunchdarklyFeatureFlagEnvironmentFallthroughOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyFeatureFlagEnvironmentFallthrough | undefined;
    set internalValue(value: DataLaunchdarklyFeatureFlagEnvironmentFallthrough | undefined);
    get bucketBy(): string;
    get contextKind(): string;
    get rolloutWeights(): number[];
    get variation(): number;
}
export declare class DataLaunchdarklyFeatureFlagEnvironmentFallthroughList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyFeatureFlagEnvironmentFallthroughOutputReference;
}
export interface DataLaunchdarklyFeatureFlagEnvironmentPrerequisites {
}
export declare function dataLaunchdarklyFeatureFlagEnvironmentPrerequisitesToTerraform(struct?: DataLaunchdarklyFeatureFlagEnvironmentPrerequisites): any;
export declare class DataLaunchdarklyFeatureFlagEnvironmentPrerequisitesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyFeatureFlagEnvironmentPrerequisites | undefined;
    set internalValue(value: DataLaunchdarklyFeatureFlagEnvironmentPrerequisites | undefined);
    get flagKey(): string;
    get variation(): number;
}
export declare class DataLaunchdarklyFeatureFlagEnvironmentPrerequisitesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyFeatureFlagEnvironmentPrerequisitesOutputReference;
}
export interface DataLaunchdarklyFeatureFlagEnvironmentRulesClauses {
}
export declare function dataLaunchdarklyFeatureFlagEnvironmentRulesClausesToTerraform(struct?: DataLaunchdarklyFeatureFlagEnvironmentRulesClauses): any;
export declare class DataLaunchdarklyFeatureFlagEnvironmentRulesClausesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyFeatureFlagEnvironmentRulesClauses | undefined;
    set internalValue(value: DataLaunchdarklyFeatureFlagEnvironmentRulesClauses | undefined);
    get attribute(): string;
    get contextKind(): string;
    get negate(): cdktf.IResolvable;
    get op(): string;
    get valueType(): string;
    get values(): string[];
}
export declare class DataLaunchdarklyFeatureFlagEnvironmentRulesClausesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyFeatureFlagEnvironmentRulesClausesOutputReference;
}
export interface DataLaunchdarklyFeatureFlagEnvironmentRules {
}
export declare function dataLaunchdarklyFeatureFlagEnvironmentRulesToTerraform(struct?: DataLaunchdarklyFeatureFlagEnvironmentRules): any;
export declare class DataLaunchdarklyFeatureFlagEnvironmentRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyFeatureFlagEnvironmentRules | undefined;
    set internalValue(value: DataLaunchdarklyFeatureFlagEnvironmentRules | undefined);
    get bucketBy(): string;
    private _clauses;
    get clauses(): DataLaunchdarklyFeatureFlagEnvironmentRulesClausesList;
    get description(): string;
    get rolloutWeights(): number[];
    get variation(): number;
}
export declare class DataLaunchdarklyFeatureFlagEnvironmentRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyFeatureFlagEnvironmentRulesOutputReference;
}
export interface DataLaunchdarklyFeatureFlagEnvironmentTargets {
}
export declare function dataLaunchdarklyFeatureFlagEnvironmentTargetsToTerraform(struct?: DataLaunchdarklyFeatureFlagEnvironmentTargets): any;
export declare class DataLaunchdarklyFeatureFlagEnvironmentTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyFeatureFlagEnvironmentTargets | undefined;
    set internalValue(value: DataLaunchdarklyFeatureFlagEnvironmentTargets | undefined);
    get values(): string[];
    get variation(): number;
}
export declare class DataLaunchdarklyFeatureFlagEnvironmentTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyFeatureFlagEnvironmentTargetsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/feature_flag_environment launchdarkly_feature_flag_environment}
*/
export declare class DataLaunchdarklyFeatureFlagEnvironment extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "launchdarkly_feature_flag_environment";
    /**
    * Generates CDKTF code for importing a DataLaunchdarklyFeatureFlagEnvironment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataLaunchdarklyFeatureFlagEnvironment to import
    * @param importFromId The id of the existing DataLaunchdarklyFeatureFlagEnvironment that should be imported. Refer to the {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/feature_flag_environment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataLaunchdarklyFeatureFlagEnvironment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.16.0/docs/data-sources/feature_flag_environment launchdarkly_feature_flag_environment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLaunchdarklyFeatureFlagEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: DataLaunchdarklyFeatureFlagEnvironmentConfig);
    private _contextTargets;
    get contextTargets(): DataLaunchdarklyFeatureFlagEnvironmentContextTargetsList;
    private _envKey?;
    get envKey(): string;
    set envKey(value: string);
    get envKeyInput(): string | undefined;
    private _fallthrough;
    get fallthrough(): DataLaunchdarklyFeatureFlagEnvironmentFallthroughList;
    private _flagId?;
    get flagId(): string;
    set flagId(value: string);
    get flagIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get offVariation(): number;
    get on(): cdktf.IResolvable;
    private _prerequisites;
    get prerequisites(): DataLaunchdarklyFeatureFlagEnvironmentPrerequisitesList;
    private _rules;
    get rules(): DataLaunchdarklyFeatureFlagEnvironmentRulesList;
    private _targets;
    get targets(): DataLaunchdarklyFeatureFlagEnvironmentTargetsList;
    get trackEvents(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
